/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.util;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class MappingUtil {
    private MappingUtil() {
    }

    @Nonnull
    public static Map<String, String> getMapping(@Nonnull List<Path> components) throws IOException {
        assert (!components.isEmpty());
        HashMap<String, String> mapping = new HashMap<String, String>();
        ArrayList<Properties> loaded = new ArrayList<Properties>();
        for (Path component : components) {
            Properties properties = new Properties();
            properties.load(new FileReader(component.toFile()));
            loaded.add(properties);
            for (String propertyName : properties.stringPropertyNames()) {
                if (mapping.containsKey(propertyName)) {
                    for (int i = 0; i < loaded.size(); ++i) {
                        if (!((Properties)loaded.get(i)).containsKey(propertyName)) continue;
                        throw new IOException("Mapping key '" + propertyName + "' appears in multiple files: " + Arrays.asList(components.get(i), component));
                    }
                    continue;
                }
                mapping.put(propertyName, properties.getProperty(propertyName));
            }
        }
        return mapping;
    }
}

