/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.document;

import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import graphql.validation.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.realityforge.giggle.document.DocumentReadException;
import org.realityforge.giggle.document.DocumentValidateException;

public final class DocumentRepository {
    @Nonnull
    private final Parser _parser = new Parser();
    @Nonnull
    private final Validator _validator = new Validator();

    @Nonnull
    public Document getDocument(@Nonnull GraphQLSchema schema, @Nonnull List<Path> components) throws DocumentReadException, DocumentValidateException {
        assert (!components.isEmpty());
        Document document = Document.newDocument().build();
        for (Path component : components) {
            document = document.transform(b -> this.mergeComponent((Document.Builder)b, component));
        }
        List errors = this._validator.validateDocument(schema, document);
        this.validateFragmentNamesUnique(document, errors);
        this.validateNoAnonymousOperations(document, errors);
        if (errors.isEmpty()) {
            return document;
        }
        throw new DocumentValidateException(errors);
    }

    private void validateFragmentNamesUnique(@Nonnull Document document, @Nonnull List<ValidationError> errors) {
        List fragments = document.getDefinitions().stream().filter(d -> d instanceof FragmentDefinition).map(d -> (FragmentDefinition)d).collect(Collectors.toList());
        HashMap<String, FragmentDefinition> fragmentMap = new HashMap<String, FragmentDefinition>();
        for (FragmentDefinition fragment : fragments) {
            String name = fragment.getName();
            FragmentDefinition existing = (FragmentDefinition)fragmentMap.get(name);
            if (null == existing) {
                fragmentMap.put(name, fragment);
                continue;
            }
            errors.add(new ValidationError(ValidationErrorType.FragmentCycle, Arrays.asList(existing.getSourceLocation(), fragment.getSourceLocation()), "Multiple fragments defined with the name '" + name + "'"));
        }
    }

    private void validateNoAnonymousOperations(@Nonnull Document document, @Nonnull List<ValidationError> errors) {
        document.getDefinitions().stream().filter(d -> d instanceof OperationDefinition).map(d -> (OperationDefinition)d).filter(d -> null == d.getName()).findAny().ifPresent(definition -> errors.add(new ValidationError(ValidationErrorType.LoneAnonymousOperationViolation, definition.getSourceLocation(), "Giggle does not allow anonymous operations.")));
    }

    private void mergeComponent(@Nonnull Document.Builder builder, @Nonnull Path component) {
        this._parser.parseDocument(this.readDocument(component), component.toString()).getDefinitions().forEach(arg_0 -> ((Document.Builder)builder).definition(arg_0));
    }

    @Nonnull
    private String readDocument(@Nonnull Path component) {
        try {
            return new String(Files.readAllBytes(component), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new DocumentReadException("Error reading file " + component, ioe);
        }
    }
}

