/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator;

import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class GeneratorContext {
    @Nonnull
    private final GraphQLSchema _schema;
    @Nonnull
    private final Document _document;
    @Nonnull
    private final Map<String, String> _typeMapping;
    @Nonnull
    private final Map<String, String> _fragmentMapping;
    @Nonnull
    private final Path _outputDirectory;
    @Nonnull
    private final String _packageName;

    public GeneratorContext(@Nonnull GraphQLSchema schema, @Nonnull Document document, @Nonnull Map<String, String> typeMapping, @Nonnull Map<String, String> fragmentMapping, @Nonnull Path outputDirectory, @Nonnull String packageName) {
        this._schema = Objects.requireNonNull(schema);
        this._document = Objects.requireNonNull(document);
        this._typeMapping = Objects.requireNonNull(typeMapping);
        this._fragmentMapping = Objects.requireNonNull(fragmentMapping);
        this._outputDirectory = Objects.requireNonNull(outputDirectory);
        this._packageName = Objects.requireNonNull(packageName);
    }

    @Nonnull
    public GraphQLSchema getSchema() {
        return this._schema;
    }

    @Nonnull
    public Document getDocument() {
        return this._document;
    }

    @Nonnull
    public Map<String, String> getTypeMapping() {
        return this._typeMapping;
    }

    @Nonnull
    public Map<String, String> getFragmentMapping() {
        return this._fragmentMapping;
    }

    @Nonnull
    public Path getOutputDirectory() {
        return this._outputDirectory;
    }

    @Nonnull
    public String getPackageName() {
        return this._packageName;
    }
}

