/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.client;

import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class FragmentCollector {
    @Nonnull
    private final Map<String, FragmentDefinition> _fragmentsByName;

    FragmentCollector(@Nonnull Document document) {
        this._fragmentsByName = document.getDefinitions().stream().filter(definition -> definition instanceof FragmentDefinition).map(definition -> (FragmentDefinition)definition).collect(Collectors.toMap(FragmentDefinition::getName, v -> v, (a, b) -> b));
    }

    @Nonnull
    List<FragmentDefinition> collectFragments(@Nonnull SelectionSet selectionSet) {
        LinkedHashMap<String, FragmentDefinition> fragments = new LinkedHashMap<String, FragmentDefinition>();
        this.collectFragments(selectionSet, new ArrayList<String>(), fragments);
        return new ArrayList<FragmentDefinition>(fragments.values());
    }

    private void collectFragments(@Nullable SelectionSet selectionSet, @Nonnull List<String> visitedFragments, @Nonnull Map<String, FragmentDefinition> fragments) {
        if (null != selectionSet) {
            for (Selection selection : selectionSet.getSelections()) {
                String name;
                if (selection instanceof SelectionSetContainer) {
                    this.collectFragments(((SelectionSetContainer)selection).getSelectionSet(), visitedFragments, fragments);
                    continue;
                }
                if (!(selection instanceof FragmentSpread) || visitedFragments.contains(name = ((FragmentSpread)selection).getName())) continue;
                visitedFragments.add(name);
                FragmentDefinition fragmentDefinition = this._fragmentsByName.get(name);
                fragments.put(name, fragmentDefinition);
                this.collectFragments(fragmentDefinition.getSelectionSet(), visitedFragments, fragments);
            }
        }
    }
}

