/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.server;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import graphql.Scalars;
import graphql.schema.CoercingParseValueException;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.java.AbstractJavaGenerator;
import org.realityforge.giggle.generator.java.JavaGenUtil;
import org.realityforge.giggle.generator.java.NamingUtil;

@Generator.MetaData(name="java-server")
public class JavaServerGenerator
extends AbstractJavaGenerator {
    private static final ParameterizedTypeName VALUE_MAP = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});

    @Override
    public void generate(@Nonnull GeneratorContext context) throws Exception {
        Map<GraphQLType, String> inputTypeMap = this.buildTypeMapping(context);
        HashMap<GraphQLType, String> generatedTypeMap = new HashMap<GraphQLType, String>();
        GraphQLSchema schema = context.getSchema();
        List types = schema.getAllTypesAsList().stream().filter(this::isNotIntrospectionType).filter(t -> !inputTypeMap.containsKey(t)).collect(Collectors.toList());
        for (GraphQLType type : types) {
            if (!(type instanceof GraphQLEnumType) && !(type instanceof GraphQLInputObjectType)) continue;
            generatedTypeMap.put(type, context.getPackageName() + "." + type.getName());
        }
        HashMap<GraphQLType, String> fullTypeMap = new HashMap<GraphQLType, String>();
        fullTypeMap.putAll(inputTypeMap);
        fullTypeMap.putAll(generatedTypeMap);
        for (GraphQLType type : types) {
            if (type instanceof GraphQLEnumType) {
                this.emitEnum(context, (GraphQLEnumType)type);
                continue;
            }
            if (type instanceof GraphQLInputObjectType) {
                this.emitInput(context, fullTypeMap, (GraphQLInputObjectType)type);
                continue;
            }
            if (!(type instanceof GraphQLFieldsContainer)) continue;
            GraphQLFieldsContainer container = (GraphQLFieldsContainer)type;
            for (GraphQLFieldDefinition definition : container.getFieldDefinitions()) {
                List arguments = definition.getArguments();
                if (arguments.isEmpty()) continue;
                String name = container.getName();
                String argsName = "Query".equals(name) || "Mutation".equals(name) ? definition.getName() : container.getName() + definition.getName();
                this.emitArgs(context, fullTypeMap, NamingUtil.uppercaseFirstCharacter(argsName) + "Args", arguments);
            }
        }
        this.writeTypeMappingFile(context, generatedTypeMap);
    }

    private void emitArgs(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull String name, @Nonnull List<GraphQLArgument> arguments) throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)name);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        HashMap<GraphQLArgument, TypeName> argTypes = new HashMap<GraphQLArgument, TypeName>();
        for (GraphQLArgument argument : arguments) {
            argTypes.put(argument, JavaGenUtil.getJavaType(typeMap, (GraphQLDirectiveContainer)argument));
        }
        builder.addMethod(this.buildArgsFrom(name, arguments, argTypes));
        this.buildArgsCoerceMethods(arguments, builder);
        builder.addMethod(this.buildArgsConstructor(arguments, argTypes));
        for (GraphQLArgument argument : arguments) {
            builder.addField(this.buildArgsArgField(argument, argTypes));
            builder.addMethod(this.buildArgsArgGetter(argument, argTypes));
        }
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    private void buildArgsCoerceMethods(@Nonnull List<GraphQLArgument> arguments, TypeSpec.Builder builder) {
        boolean coerceTrapRequired = false;
        boolean coerceForID = false;
        boolean maybeCoerceForID = false;
        for (GraphQLArgument argument : arguments) {
            GraphQLUnmodifiedType inputType;
            if (this.isNumericIDType((GraphQLDirectiveContainer)argument, (GraphQLType)(inputType = GraphQLTypeUtil.unwrapAll((GraphQLType)argument.getType())))) {
                boolean listMayContainNulls;
                coerceForID = true;
                coerceTrapRequired = true;
                boolean isListType = JavaGenUtil.isList((GraphQLType)argument.getType());
                boolean nonNull = GraphQLTypeUtil.isNonNull((GraphQLType)argument.getType());
                boolean bl = listMayContainNulls = isListType && !GraphQLTypeUtil.isNonNull((GraphQLType)GraphQLTypeUtil.unwrapOne((GraphQLType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)argument.getType())));
                if (!listMayContainNulls && (isListType || nonNull)) continue;
                maybeCoerceForID = true;
                continue;
            }
            if (!this.isCoerceTrapRequired(argument)) continue;
            coerceTrapRequired = true;
        }
        if (coerceTrapRequired) {
            builder.addMethod(this.buildArgsCoerceTrap());
            if (coerceForID) {
                builder.addMethod(this.buildCoerceID("argument"));
                if (maybeCoerceForID) {
                    builder.addMethod(this.buildMaybeCoerceID());
                }
            }
        }
    }

    private boolean isCoerceTrapRequired(@Nonnull GraphQLArgument type) {
        GraphQLUnmodifiedType inputType = GraphQLTypeUtil.unwrapAll((GraphQLType)type.getType());
        return this.isNumericIDType((GraphQLDirectiveContainer)type, (GraphQLType)inputType) || inputType instanceof GraphQLInputObjectType && ((GraphQLInputObjectType)inputType).getFields().stream().anyMatch(this::isCoerceTrapRequired);
    }

    private boolean isNumericIDType(@Nonnull GraphQLDirectiveContainer container, @Nonnull GraphQLType inputType) {
        return Scalars.GraphQLID.getName().equals(inputType.getName()) && JavaGenUtil.hasNumericDirective(container);
    }

    private boolean isCoerceTrapRequired(@Nonnull GraphQLInputObjectField type) {
        return this.isCoerceTrapRequired(type, new HashSet<String>());
    }

    private boolean isCoerceTrapRequired(@Nonnull GraphQLInputObjectField type, @Nonnull Set<String> typesProcessed) {
        GraphQLUnmodifiedType inputType = GraphQLTypeUtil.unwrapAll((GraphQLType)type.getType());
        if (this.isNumericIDType((GraphQLDirectiveContainer)type, (GraphQLType)inputType)) {
            return true;
        }
        String name = inputType.getName();
        if (inputType instanceof GraphQLInputObjectType && !typesProcessed.contains(name)) {
            typesProcessed.add(name);
            List fields = ((GraphQLInputObjectType)inputType).getFields();
            return fields.stream().anyMatch(f -> this.isCoerceTrapRequired((GraphQLInputObjectField)f, typesProcessed));
        }
        return false;
    }

    @Nonnull
    private MethodSpec buildArgsCoerceTrap() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"coerceTrap");
        method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        method.addAnnotation(Nonnull.class);
        TypeVariableName type = TypeVariableName.get((String)"T");
        method.addTypeVariable(type);
        method.returns((TypeName)type);
        method.addParameter(ParameterSpec.builder(DataFetchingEnvironment.class, (String)"environment", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build());
        method.addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{type}), (String)"supplier", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("try", new Object[0]);
        block.addStatement("return supplier.get()", new Object[0]);
        block.nextControlFlow("catch ( final $T e )", new Object[]{CoercingParseValueException.class});
        block.addStatement("throw new $T( e.getMessage(), e.getCause(), environment.getMergedField().getSingleField().getSourceLocation() )", new Object[]{CoercingParseValueException.class});
        block.endControlFlow();
        method.addCode(block.build());
        return method.build();
    }

    @Nonnull
    private MethodSpec buildCoerceID(@Nonnull String type) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow("try", new Object[0]);
        code.addStatement("return $T.decode( value )", new Object[]{Integer.class});
        code.nextControlFlow("catch ( final $T e )", new Object[]{NumberFormatException.class});
        code.addStatement("throw new $T( \"Failed to parse $N '\" + name + \"' that was expected to be a numeric ID type. Actual value = '\" + value + \"'\" )", new Object[]{CoercingParseValueException.class, type});
        code.endControlFlow();
        return MethodSpec.methodBuilder((String)"coerceID").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(ParameterSpec.builder(String.class, (String)"name", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build()).addParameter(ParameterSpec.builder(String.class, (String)"value", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build()).addAnnotation(Nonnull.class).returns(Integer.class).addCode(code.build()).build();
    }

    @Nonnull
    private MethodSpec buildMaybeCoerceID() {
        return MethodSpec.methodBuilder((String)"maybeCoerceID").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(ParameterSpec.builder(String.class, (String)"name", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build()).addParameter(ParameterSpec.builder(String.class, (String)"value", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addAnnotation(Nullable.class).returns(Integer.class).addStatement("return null == value ? null : coerceID( name, value )", new Object[0]).build();
    }

    @Nonnull
    private MethodSpec buildArgsFrom(@Nonnull String className, @Nonnull List<GraphQLArgument> arguments, @Nonnull Map<GraphQLArgument, TypeName> argTypes) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"from");
        method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        method.addAnnotation(Nonnull.class);
        ClassName self = ClassName.bestGuess((String)className);
        method.returns((TypeName)self);
        method.addParameter(ParameterSpec.builder(DataFetchingEnvironment.class, (String)"environment", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build());
        method.addStatement("final $T args = environment.getArguments()", new Object[]{VALUE_MAP});
        boolean suppressedUnchecked = false;
        boolean coerceTrapRequired = false;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(self);
        for (GraphQLArgument argument : arguments) {
            String prefix;
            boolean listMayContainNulls;
            String argName = argument.getName();
            String name = "$giggle$_" + argName;
            TypeName typeName = argTypes.get(argument);
            GraphQLInputType graphQLType = argument.getType();
            GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)graphQLType);
            boolean isInputType = unwrappedType instanceof GraphQLInputObjectType;
            boolean coerceRequired = this.isCoerceTrapRequired(argument);
            boolean isListType = JavaGenUtil.isList((GraphQLType)graphQLType);
            boolean nonNull = GraphQLTypeUtil.isNonNull((GraphQLType)graphQLType);
            boolean bl = listMayContainNulls = isListType && !GraphQLTypeUtil.isNonNull((GraphQLType)GraphQLTypeUtil.unwrapOne((GraphQLType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)graphQLType)));
            if (coerceRequired) {
                coerceTrapRequired = true;
            }
            if ((isInputType || isListType) && !suppressedUnchecked) {
                suppressedUnchecked = true;
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
            }
            ParameterizedTypeName javaType = isInputType && isListType ? JavaGenUtil.listOf((TypeName)VALUE_MAP) : (isInputType ? VALUE_MAP : (isListType && coerceRequired ? JavaGenUtil.listOf((TypeName)ClassName.get(String.class)) : (coerceRequired ? ClassName.get(String.class) : typeName)));
            method.addStatement("final $T $N = ($T) args.get( $S )", new Object[]{javaType, name, javaType.isPrimitive() ? javaType.box() : javaType, argName});
            if (isInputType) {
                if (isListType) {
                    if (nonNull) {
                        prefix = "";
                    } else {
                        prefix = "null == $N ? null : ";
                        args.add(name);
                    }
                    params.add(prefix + "$N.stream().map( $T::$N ).collect( $T.toList() )");
                    args.add(name);
                    args.add(((ParameterizedTypeName)typeName).typeArguments.get(0));
                    args.add(listMayContainNulls ? "maybeFrom" : "from");
                    args.add(Collectors.class);
                    continue;
                }
                params.add("$T.$N( $N )");
                args.add(typeName);
                args.add(nonNull ? "from" : "maybeFrom");
                args.add(name);
                continue;
            }
            if (coerceRequired && isListType) {
                if (nonNull) {
                    prefix = "";
                } else {
                    prefix = "null == $N ? null : ";
                    args.add(name);
                }
                params.add(prefix + "$N.stream().map( v -> $N( $S, v ) ).collect( $T.toList() )");
                args.add(name);
                args.add(listMayContainNulls ? "maybeCoerceID" : "coerceID");
                args.add(argName);
                args.add(Collectors.class);
                continue;
            }
            if (coerceRequired) {
                params.add("$N( $S, $N )");
                args.add(nonNull ? "coerceID" : "maybeCoerceID");
                args.add(argName);
                args.add(name);
                continue;
            }
            params.add("$N");
            args.add(name);
        }
        if (coerceTrapRequired) {
            method.addStatement("return coerceTrap( environment, () -> new $T(" + String.join((CharSequence)", ", params) + ") )", args.toArray());
        } else {
            method.addStatement("return new $T(" + String.join((CharSequence)", ", params) + ")", args.toArray());
        }
        return method.build();
    }

    @Nonnull
    private MethodSpec buildArgsConstructor(@Nonnull List<GraphQLArgument> arguments, @Nonnull Map<GraphQLArgument, TypeName> argTypes) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (GraphQLArgument argument : arguments) {
            GraphQLInputType fieldType = argument.getType();
            TypeName javaType = argTypes.get(argument);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)argument.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldType) ? Nonnull.class : Nullable.class);
            }
            ctor.addParameter(parameter.build());
            if (GraphQLTypeUtil.isNonNull((GraphQLType)fieldType) && !javaType.isPrimitive()) {
                ctor.addStatement("this.$N = $T.requireNonNull( $N )", new Object[]{argument.getName(), Objects.class, argument.getName()});
                continue;
            }
            ctor.addStatement("this.$N = $N", new Object[]{argument.getName(), argument.getName()});
        }
        return ctor.build();
    }

    @Nonnull
    private MethodSpec buildArgsArgGetter(@Nonnull GraphQLArgument argument, @Nonnull Map<GraphQLArgument, TypeName> argTypes) {
        String description;
        String name = argument.getName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + NamingUtil.uppercaseFirstCharacter(name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        TypeName javaType = argTypes.get(argument);
        builder.returns(javaType);
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)argument.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = argument.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        builder.addStatement("return $N", new Object[]{name});
        return builder.build();
    }

    @Nonnull
    private FieldSpec buildArgsArgField(@Nonnull GraphQLArgument argument, @Nonnull Map<GraphQLArgument, TypeName> argTypes) {
        String description;
        TypeName javaType = argTypes.get(argument);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)javaType, (String)argument.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)argument.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = argument.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        return builder.build();
    }

    private void emitInput(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLInputObjectType type) throws IOException {
        ClassName self = ClassName.bestGuess((String)typeMap.get(type));
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)type.getName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        String description = type.getDescription();
        if (null != description) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        HashMap<GraphQLInputObjectField, TypeName> fieldTypes = new HashMap<GraphQLInputObjectField, TypeName>();
        for (GraphQLInputObjectField field : type.getFields()) {
            fieldTypes.put(field, JavaGenUtil.getJavaType(typeMap, (GraphQLDirectiveContainer)field));
        }
        builder.addMethod(this.buildInputFrom(type, typeMap, fieldTypes));
        builder.addMethod(this.buildInputMaybeFrom(type, typeMap));
        this.buildInputCoerceMethods(type.getFields(), builder);
        builder.addMethod(this.buildInputConstructor(type, fieldTypes));
        for (GraphQLInputObjectField field : type.getFields()) {
            builder.addField(this.buildInputFieldField(field, fieldTypes));
            builder.addMethod(this.buildInputFieldGetter(field, fieldTypes));
        }
        builder.addMethod(this.buildInputEquals(self, type));
        builder.addMethod(this.buildInputHashCode(type));
        builder.addMethod(this.buildInputToString(type));
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    private void buildInputCoerceMethods(@Nonnull List<GraphQLInputObjectField> fields, @Nonnull TypeSpec.Builder builder) {
        boolean coerceForID = false;
        boolean maybeCoerceForID = false;
        for (GraphQLInputObjectField field : fields) {
            boolean listMayContainNulls;
            GraphQLUnmodifiedType inputType;
            if (!this.isNumericIDType((GraphQLDirectiveContainer)field, (GraphQLType)(inputType = GraphQLTypeUtil.unwrapAll((GraphQLType)field.getType())))) continue;
            coerceForID = true;
            boolean isListType = JavaGenUtil.isList((GraphQLType)field.getType());
            boolean nonNull = GraphQLTypeUtil.isNonNull((GraphQLType)field.getType());
            boolean bl = listMayContainNulls = isListType && !GraphQLTypeUtil.isNonNull((GraphQLType)GraphQLTypeUtil.unwrapOne((GraphQLType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)inputType)));
            if (!listMayContainNulls && (isListType || nonNull)) continue;
            maybeCoerceForID = true;
        }
        if (coerceForID) {
            builder.addMethod(this.buildCoerceID("input field"));
            if (maybeCoerceForID) {
                builder.addMethod(this.buildMaybeCoerceID());
            }
        }
    }

    @Nonnull
    private MethodSpec buildInputEquals(@Nonnull ClassName self, @Nonnull GraphQLInputObjectType type) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "o", new Modifier[]{Modifier.FINAL}).returns(TypeName.BOOLEAN);
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( this == o )", new Object[0]);
        codeBlock.addStatement("return true", new Object[0]);
        codeBlock.nextControlFlow("else if ( !( o instanceof $T ) )", new Object[]{self});
        codeBlock.addStatement("return false", new Object[0]);
        codeBlock.nextControlFlow("else", new Object[0]);
        codeBlock.addStatement("final $T that = ($T) o", new Object[]{self, self});
        ArrayList args = new ArrayList();
        String expr = type.getFields().stream().map(field -> {
            args.add(Objects.class);
            args.add(field.getName());
            args.add(field.getName());
            return "$T.equals( $N, that.$N )";
        }).collect(Collectors.joining(" && "));
        codeBlock.addStatement("return " + expr, args.toArray());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        return method.build();
    }

    @Nonnull
    private MethodSpec buildInputHashCode(@Nonnull GraphQLInputObjectType type) {
        String fields = type.getFields().stream().map(f -> "$N").collect(Collectors.joining(", "));
        return MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.INT).addStatement("return $T.hash( " + fields + " )", Stream.concat(Stream.of(Objects.class), type.getFields().stream().map(GraphQLInputObjectField::getName)).toArray()).build();
    }

    @Nonnull
    private MethodSpec buildInputToString(@Nonnull GraphQLInputObjectType type) {
        String fields = type.getFields().stream().map(f -> "$N=\" + $N").collect(Collectors.joining(" + \", "));
        return MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return \"$N[" + fields + " + \"]\"", Stream.concat(Stream.of(type.getName()), type.getFields().stream().flatMap(field -> Stream.of(field.getName(), field.getName()))).toArray()).build();
    }

    @Nonnull
    private MethodSpec buildInputMaybeFrom(@Nonnull GraphQLInputObjectType type, @Nonnull Map<GraphQLType, String> typeMap) {
        return MethodSpec.methodBuilder((String)"maybeFrom").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Nullable.class).returns((TypeName)ClassName.bestGuess((String)typeMap.get(type))).addParameter(ParameterSpec.builder((TypeName)VALUE_MAP, (String)"args", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("return null == args ? null : from( args )", new Object[0]).build();
    }

    @Nonnull
    private MethodSpec buildInputFrom(@Nonnull GraphQLInputObjectType type, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"from");
        method.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        method.addAnnotation(Nonnull.class);
        ClassName self = ClassName.bestGuess((String)typeMap.get(type));
        method.returns((TypeName)self);
        method.addParameter(ParameterSpec.builder((TypeName)VALUE_MAP, (String)"args", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build());
        boolean suppressedUnchecked = false;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(self);
        for (GraphQLInputObjectField field : type.getFields()) {
            String prefix;
            boolean listMayContainNulls;
            String fieldName = field.getName();
            String name = "$giggle$_" + fieldName;
            TypeName typeName = fieldTypes.get(field);
            GraphQLInputType graphQLType = field.getType();
            GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll((GraphQLType)graphQLType);
            boolean isInputType = unwrappedType instanceof GraphQLInputObjectType;
            boolean coerceRequired = this.isNumericIDType((GraphQLDirectiveContainer)field, (GraphQLType)unwrappedType);
            boolean isListType = JavaGenUtil.isList((GraphQLType)graphQLType);
            boolean nonNull = GraphQLTypeUtil.isNonNull((GraphQLType)graphQLType);
            boolean bl = listMayContainNulls = isListType && !GraphQLTypeUtil.isNonNull((GraphQLType)GraphQLTypeUtil.unwrapOne((GraphQLType)GraphQLTypeUtil.unwrapNonNull((GraphQLType)graphQLType)));
            if ((isInputType || isListType) && !suppressedUnchecked) {
                suppressedUnchecked = true;
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
            }
            ParameterizedTypeName javaType = isInputType && isListType ? JavaGenUtil.listOf((TypeName)VALUE_MAP) : (isInputType ? VALUE_MAP : (isListType && coerceRequired ? JavaGenUtil.listOf((TypeName)ClassName.get(String.class)) : (coerceRequired ? ClassName.get(String.class) : typeName)));
            method.addStatement("final $T $N = ($T) args.get( $S )", new Object[]{javaType, name, javaType.isPrimitive() ? javaType.box() : javaType, fieldName});
            if (isInputType) {
                if (isListType) {
                    if (nonNull) {
                        prefix = "";
                    } else {
                        prefix = "null == $N ? null : ";
                        args.add(name);
                    }
                    params.add(prefix + "$N.stream().map( $T::$N ).collect( $T.toList() )");
                    args.add(name);
                    args.add(((ParameterizedTypeName)typeName).typeArguments.get(0));
                    args.add(listMayContainNulls ? "maybeFrom" : "from");
                    args.add(Collectors.class);
                    continue;
                }
                params.add("$T.$N( $N )");
                args.add(typeName);
                args.add(nonNull ? "from" : "maybeFrom");
                args.add(name);
                continue;
            }
            if (coerceRequired && isListType) {
                if (nonNull) {
                    prefix = "";
                } else {
                    prefix = "null == $N ? null : ";
                    args.add(name);
                }
                params.add(prefix + "$N.stream().map( v -> $N( $S, v ) ).collect( $T.toList() )");
                args.add(name);
                args.add(listMayContainNulls ? "maybeCoerceID" : "coerceID");
                args.add(fieldName);
                args.add(Collectors.class);
                continue;
            }
            if (coerceRequired) {
                params.add("$N( $S, $N )");
                args.add(nonNull ? "coerceID" : "maybeCoerceID");
                args.add(fieldName);
                args.add(name);
                continue;
            }
            params.add("$N");
            args.add(name);
        }
        method.addStatement("return new $T(" + String.join((CharSequence)", ", params) + ")", args.toArray());
        return method.build();
    }

    @Nonnull
    private MethodSpec buildInputConstructor(@Nonnull GraphQLInputObjectType type, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (GraphQLInputObjectField field : type.getFields()) {
            GraphQLInputType fieldType = field.getType();
            TypeName javaType = fieldTypes.get(field);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)field.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldType) ? Nonnull.class : Nullable.class);
            }
            ctor.addParameter(parameter.build());
            if (GraphQLTypeUtil.isNonNull((GraphQLType)fieldType)) {
                ctor.addStatement("this.$N = $T.requireNonNull( $N )", new Object[]{field.getName(), Objects.class, field.getName()});
                continue;
            }
            ctor.addStatement("this.$N = $N", new Object[]{field.getName(), field.getName()});
        }
        return ctor.build();
    }

    @Nonnull
    private MethodSpec buildInputFieldGetter(@Nonnull GraphQLInputObjectField field, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        GraphQLDirective deprecated;
        String description;
        String name = field.getName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + NamingUtil.uppercaseFirstCharacter(name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        TypeName javaType = fieldTypes.get(field);
        builder.returns(javaType);
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)field.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = field.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        if (null != (deprecated = field.getDirective("deprecated"))) {
            builder.addJavadoc("@deprecated " + deprecated.getArgument("reason") + "\n", new Object[0]);
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        builder.addStatement("return $N", new Object[]{name});
        return builder.build();
    }

    @Nonnull
    private FieldSpec buildInputFieldField(@Nonnull GraphQLInputObjectField field, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        GraphQLDirective deprecated;
        String description;
        TypeName javaType = fieldTypes.get(field);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)javaType, (String)field.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)field.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = field.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        if (null != (deprecated = field.getDirective("deprecated"))) {
            builder.addJavadoc("@deprecated " + deprecated.getArgument("reason") + "\n", new Object[0]);
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        return builder.build();
    }
}

