/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.java.JavaGenUtil;

public abstract class AbstractJavaGenerator
extends Generator {
    protected static final String GEN_PREFIX = "$giggle$_";

    @Nonnull
    protected final String asJavadoc(@Nonnull String text) {
        return text.trim() + "\n";
    }

    protected final boolean isNotIntrospectionType(@Nonnull GraphQLType type) {
        return !type.getName().startsWith("__");
    }

    protected final void writeTypeMappingFile(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap) throws IOException {
        String typeMappingContent = typeMap.keySet().stream().map(type -> type.getName() + "=" + (String)typeMap.get(type)).sorted().collect(Collectors.joining("\n")) + "\n";
        this.writeFile(this.getPackageOutputDirectory(context).resolve("types.mapping"), typeMappingContent);
    }

    @Nonnull
    protected final Path getPackageOutputDirectory(@Nonnull GeneratorContext context) {
        return context.getOutputDirectory().resolve(context.getPackageName().replaceAll("\\.", File.separator));
    }

    protected final void writeFile(@Nonnull Path file, @Nonnull String content) throws IOException {
        this.writeFile(file, content.getBytes(StandardCharsets.US_ASCII));
    }

    protected final void writeFile(@Nonnull Path file, @Nonnull byte[] bytes) throws IOException {
        Path dir = file.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Files.write(file, bytes, new OpenOption[0]);
    }

    @Nonnull
    protected final List<GraphQLType> extractTypesToGenerate(@Nonnull GraphQLSchema schema, @Nonnull Map<GraphQLType, String> existing) {
        return schema.getAllTypesAsList().stream().filter(this::isNotIntrospectionType).filter(t -> !existing.containsKey(t)).collect(Collectors.toList());
    }

    @Nonnull
    protected final Map<GraphQLType, String> extractGeneratedDataTypes(@Nonnull GeneratorContext context, @Nonnull List<GraphQLType> types) {
        HashMap<GraphQLType, String> generatedTypeMap = new HashMap<GraphQLType, String>();
        for (GraphQLType type : types) {
            if (!(type instanceof GraphQLEnumType) && !(type instanceof GraphQLInputObjectType)) continue;
            generatedTypeMap.put(type, context.getPackageName() + "." + type.getName());
        }
        return generatedTypeMap;
    }

    @Nonnull
    protected final Map<GraphQLType, String> buildTypeMapping(@Nonnull GeneratorContext context) {
        HashMap<GraphQLType, String> typeMap = new HashMap<GraphQLType, String>();
        context.getTypeMapping().forEach((key, value) -> typeMap.put(context.getSchema().getType(key), (String)value));
        return typeMap;
    }

    protected final void emitEnum(@Nonnull GeneratorContext context, @Nonnull GraphQLEnumType type) throws IOException {
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)type.getName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        String description = type.getDescription();
        if (null != description) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        type.getValues().forEach(value -> this.emitEnumValue(builder, (GraphQLEnumValueDefinition)value));
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    private void emitEnumValue(@Nonnull TypeSpec.Builder enumBuilder, @Nonnull GraphQLEnumValueDefinition value) {
        String deprecationReason;
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        String description = value.getDescription();
        if (null != description) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        if (null != (deprecationReason = value.getDeprecationReason())) {
            builder.addJavadoc("@deprecated " + deprecationReason + "\n", new Object[0]);
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        enumBuilder.addEnumConstant(value.getName(), builder.build());
    }
}

