/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.GenerateException;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.GlobalGeneratorContext;
import org.realityforge.giggle.generator.PropertyDef;

public final class GeneratorEntry {
    @Nonnull
    private final String _name;
    @Nonnull
    private final Map<String, PropertyDef> _properties;
    @Nonnull
    private final Generator _generator;

    public GeneratorEntry(@Nonnull Generator generator) {
        Class<?> type = generator.getClass();
        Generator.MetaData metaData = type.getAnnotation(Generator.MetaData.class);
        String name = null == metaData ? "<default>" : metaData.name();
        this._name = "<default>".equals(name) ? type.getSimpleName().replaceAll("Generator$", "") : name;
        this._generator = Objects.requireNonNull(generator);
        LinkedHashMap<String, PropertyDef> map = new LinkedHashMap<String, PropertyDef>();
        for (PropertyDef propertyDef : generator.getSupportedProperties()) {
            map.put(propertyDef.getKey(), propertyDef);
        }
        this._properties = Collections.unmodifiableMap(map);
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public Map<String, PropertyDef> getSupportedProperties() {
        return this._properties;
    }

    @Nonnull
    public Generator getGenerator() {
        return this._generator;
    }

    public void generate(@Nonnull GlobalGeneratorContext context) throws GenerateException {
        try {
            this.getGenerator().generate(new GeneratorContext(this, context));
        }
        catch (Throwable t) {
            throw new GenerateException(this.getName(), t.getMessage(), t);
        }
    }

    @Nonnull
    public PropertyDef getProperty(@Nonnull String name) {
        PropertyDef propertyDef = this._properties.get(name);
        if (null == propertyDef) {
            String message = "Generator named '" + this.getName() + "' attempted to access property named '" + name + "' but did not declare property";
            throw new IllegalStateException(message);
        }
        return propertyDef;
    }
}

