/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.client;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.language.AstPrinter;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSetContainer;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.java.AbstractJavaGenerator;
import org.realityforge.giggle.generator.java.JavaGenUtil;
import org.realityforge.giggle.generator.java.NamingUtil;
import org.realityforge.giggle.generator.java.client.FieldCollector;
import org.realityforge.giggle.generator.java.client.FragmentCollector;
import org.realityforge.giggle.util.GraphQLUtil;

@Generator.MetaData(name="java-client")
public class JavaClientGenerator
extends AbstractJavaGenerator {
    private static final String GRAPH_QL_ERROR_TYPE_NAME = "GraphQLError";

    @Override
    public void generate(@Nonnull GeneratorContext context) throws Exception {
        Map<GraphQLType, String> inputTypeMap = this.buildTypeMapping(context);
        List<GraphQLType> types = this.extractTypesToGenerate(context.getSchema(), inputTypeMap);
        Map<GraphQLType, String> generatedTypeMap = this.extractGeneratedDataTypes(context, types);
        HashMap<GraphQLType, String> fullTypeMap = new HashMap<GraphQLType, String>(inputTypeMap);
        fullTypeMap.putAll(generatedTypeMap);
        this.emitGraphQLError(context);
        this.emitEnums(context, types);
        this.emitInputs(context, fullTypeMap, types);
        this.emitOperations(context, fullTypeMap);
        this.writeTypeMappingFile(context, generatedTypeMap);
    }

    private void emitEnums(@Nonnull GeneratorContext context, @Nonnull List<GraphQLType> types) throws IOException {
        for (GraphQLType type : types) {
            if (!(type instanceof GraphQLEnumType)) continue;
            this.emitEnum(context, (GraphQLEnumType)type);
        }
    }

    private void emitInputs(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> fullTypeMap, @Nonnull List<GraphQLType> types) throws IOException {
        for (GraphQLType type : types) {
            if (!(type instanceof GraphQLInputObjectType)) continue;
            this.emitInput(context, fullTypeMap, (GraphQLInputObjectType)type);
        }
    }

    private void emitOperations(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap) throws IOException {
        FieldCollector collector = new FieldCollector(context.getDocument());
        FragmentCollector fragmentCollector = new FragmentCollector(context.getDocument());
        for (Definition definition : context.getDocument().getDefinitions()) {
            OperationDefinition operation;
            if (!(definition instanceof OperationDefinition) || OperationDefinition.Operation.SUBSCRIPTION == (operation = (OperationDefinition)definition).getOperation()) continue;
            this.emitOperationResponse(context, collector, typeMap, operation);
            this.emitOperationType(context, fragmentCollector, typeMap, operation);
        }
    }

    private void emitInput(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLInputObjectType type) throws IOException {
        ClassName self = ClassName.bestGuess((String)typeMap.get(type));
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)type.getName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        String description = type.getDescription();
        if (null != description) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        HashMap<GraphQLInputObjectField, TypeName> fieldTypes = new HashMap<GraphQLInputObjectField, TypeName>();
        for (GraphQLInputObjectField field : type.getFields()) {
            fieldTypes.put(field, JavaGenUtil.getJavaType(typeMap, (GraphQLDirectiveContainer)field));
        }
        builder.addMethod(this.buildInputConstructor(type, fieldTypes));
        for (GraphQLInputObjectField field : type.getFields()) {
            builder.addField(this.buildInputFieldField(field, fieldTypes));
            builder.addMethod(this.buildInputFieldGetter(field, fieldTypes));
        }
        builder.addMethod(this.buildInputEquals(self, type));
        builder.addMethod(this.buildInputHashCode(type));
        builder.addMethod(this.buildInputToString(type));
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    @Nonnull
    private MethodSpec buildInputConstructor(@Nonnull GraphQLInputObjectType type, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (GraphQLInputObjectField field : type.getFields()) {
            GraphQLInputType fieldType = field.getType();
            TypeName javaType = fieldTypes.get(field);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)field.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldType) ? Nonnull.class : Nullable.class);
            }
            ctor.addParameter(parameter.build());
            if (GraphQLTypeUtil.isNonNull((GraphQLType)fieldType)) {
                ctor.addStatement("this.$N = $T.requireNonNull( $N )", new Object[]{field.getName(), Objects.class, field.getName()});
                continue;
            }
            ctor.addStatement("this.$N = $N", new Object[]{field.getName(), field.getName()});
        }
        return ctor.build();
    }

    @Nonnull
    private MethodSpec buildInputFieldGetter(@Nonnull GraphQLInputObjectField field, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        GraphQLDirective deprecated;
        String description;
        String name = field.getName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + NamingUtil.uppercaseFirstCharacter(name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        TypeName javaType = fieldTypes.get(field);
        builder.returns(javaType);
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)field.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = field.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        if (null != (deprecated = field.getDirective("deprecated"))) {
            builder.addJavadoc("@deprecated " + deprecated.getArgument("reason") + "\n", new Object[0]);
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        builder.addStatement("return $N", new Object[]{name});
        return builder.build();
    }

    @Nonnull
    private FieldSpec buildInputFieldField(@Nonnull GraphQLInputObjectField field, @Nonnull Map<GraphQLInputObjectField, TypeName> fieldTypes) {
        GraphQLDirective deprecated;
        String description;
        TypeName javaType = fieldTypes.get(field);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)javaType, (String)field.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)field.getType()) ? Nonnull.class : Nullable.class);
        }
        if (null != (description = field.getDescription())) {
            builder.addJavadoc(this.asJavadoc(description), new Object[0]);
        }
        if (null != (deprecated = field.getDirective("deprecated"))) {
            builder.addJavadoc("@deprecated " + deprecated.getArgument("reason") + "\n", new Object[0]);
            builder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        return builder.build();
    }

    @Nonnull
    private MethodSpec buildInputEquals(@Nonnull ClassName self, @Nonnull GraphQLInputObjectType type) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "o", new Modifier[]{Modifier.FINAL}).returns(TypeName.BOOLEAN);
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( this == o )", new Object[0]);
        codeBlock.addStatement("return true", new Object[0]);
        codeBlock.nextControlFlow("else if ( !( o instanceof $T ) )", new Object[]{self});
        codeBlock.addStatement("return false", new Object[0]);
        codeBlock.nextControlFlow("else", new Object[0]);
        codeBlock.addStatement("final $T that = ($T) o", new Object[]{self, self});
        ArrayList args = new ArrayList();
        String expr = type.getFields().stream().map(field -> {
            args.add(Objects.class);
            args.add(field.getName());
            args.add(field.getName());
            return "$T.equals( $N, that.$N )";
        }).collect(Collectors.joining(" && "));
        codeBlock.addStatement("return " + expr, args.toArray());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        return method.build();
    }

    @Nonnull
    private MethodSpec buildInputHashCode(@Nonnull GraphQLInputObjectType type) {
        String fields = type.getFields().stream().map(f -> "$N").collect(Collectors.joining(", "));
        return MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.INT).addStatement("return $T.hash( " + fields + " )", Stream.concat(Stream.of(Objects.class), type.getFields().stream().map(GraphQLInputObjectField::getName)).toArray()).build();
    }

    @Nonnull
    private MethodSpec buildInputToString(@Nonnull GraphQLInputObjectType type) {
        String fields = type.getFields().stream().map(f -> "$N=\" + $N").collect(Collectors.joining(" + \", "));
        return MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return \"$N[" + fields + " + \"]\"", Stream.concat(Stream.of(type.getName()), type.getFields().stream().flatMap(field -> Stream.of(field.getName(), field.getName()))).toArray()).build();
    }

    @Nonnull
    private String toCompactDocument(@Nonnull GeneratorContext context, @Nonnull FragmentCollector collector, @Nonnull OperationDefinition operation) {
        ArrayList<FragmentDefinition> definitions = new ArrayList<FragmentDefinition>(collector.collectFragments(operation.getSelectionSet()));
        definitions.add((FragmentDefinition)operation);
        Document document = context.getDocument().transform(b -> b.definitions((List)definitions));
        return AstPrinter.printAstCompact((Node)document);
    }

    private void emitOperationType(@Nonnull GeneratorContext context, @Nonnull FragmentCollector fragmentCollector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull OperationDefinition operation) throws IOException {
        String name = operation.getName();
        assert (null != name);
        OperationDefinition.Operation operationType = operation.getOperation();
        String typeName = NamingUtil.uppercaseFirstCharacter(name) + GraphQLUtil.getTopLevelFieldName(operationType);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)typeName);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.addField(FieldSpec.builder(String.class, (String)"QUERY", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addAnnotation(Nonnull.class).initializer("$S", new Object[]{this.toCompactDocument(context, fragmentCollector, operation)}).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        if (!operation.getVariableDefinitions().isEmpty()) {
            builder.addType(this.buildVariableType(typeMap, operation).build());
        }
        builder.addType(this.buildQuestionType(typeMap, operation).build());
        builder.addType(this.buildAnswerType(operation).build());
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    private void emitOperationResponse(@Nonnull GeneratorContext context, @Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull OperationDefinition operation) throws IOException {
        GraphQLObjectType fieldsContainer;
        String name = operation.getName();
        assert (null != name);
        OperationDefinition.Operation operationType = operation.getOperation();
        String typeName = NamingUtil.uppercaseFirstCharacter(name) + "Response";
        GraphQLSchema schema = context.getSchema();
        GraphQLObjectType graphQLObjectType = OperationDefinition.Operation.QUERY == operationType ? schema.getQueryType() : (fieldsContainer = OperationDefinition.Operation.MUTATION == operationType ? schema.getMutationType() : schema.getSubscriptionType());
        assert (null != fieldsContainer);
        JavaGenUtil.writeTopLevelType(context, this.buildType(collector, (SelectionSetContainer)operation, typeMap, typeName, (GraphQLFieldsContainer)fieldsContainer));
    }

    @Nonnull
    private TypeSpec.Builder buildType(@Nonnull FieldCollector collector, @Nonnull SelectionSetContainer container, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull String typeName, @Nonnull GraphQLFieldsContainer fieldsContainer) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)typeName);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.buildSelectedValues(collector, typeMap, fieldsContainer, container, builder);
        return builder;
    }

    private void buildSelectedValues(@Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLFieldsContainer fieldsContainer, @Nonnull SelectionSetContainer selectionSetContainer, @Nonnull TypeSpec.Builder builder) {
        MergedSelectionSet selectionSet = collector.collectFields(selectionSetContainer.getSelectionSet());
        for (MergedField field : selectionSet.getSubFields().values()) {
            this.buildFieldSelection(collector, typeMap, fieldsContainer, builder, field);
        }
    }

    private void buildFieldSelection(@Nonnull FieldCollector collector, @Nonnull Map<GraphQLType, String> typeMap, @Nonnull GraphQLFieldsContainer fieldsContainer, @Nonnull TypeSpec.Builder builder, @Nonnull MergedField mergedField) {
        List comments;
        TypeName fieldType;
        Field selection = mergedField.getSingleField();
        String alias = selection.getAlias();
        String name = null == alias ? selection.getName() : alias;
        GraphQLFieldDefinition fieldDefinition = fieldsContainer.getFieldDefinition(selection.getName());
        assert (null != fieldDefinition);
        if (selection.getChildren().isEmpty()) {
            fieldType = JavaGenUtil.getJavaType(typeMap, (GraphQLDirectiveContainer)fieldDefinition);
        } else {
            GraphQLObjectType type = (GraphQLObjectType)GraphQLTypeUtil.unwrapAll((GraphQLType)fieldDefinition.getType());
            String typeName = NamingUtil.uppercaseFirstCharacter(name);
            TypeSpec.Builder subType = this.buildType(collector, (SelectionSetContainer)selection, typeMap, typeName, (GraphQLFieldsContainer)type);
            subType.addModifiers(new Modifier[]{Modifier.STATIC});
            builder.addType(subType.build());
            boolean isList = JavaGenUtil.isList((GraphQLType)fieldDefinition.getType());
            ClassName jpType = ClassName.bestGuess((String)typeName);
            fieldType = isList ? JavaGenUtil.listOf((TypeName)jpType) : jpType;
        }
        FieldSpec.Builder field = FieldSpec.builder((TypeName)fieldType, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE});
        if (!fieldType.isPrimitive()) {
            field.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? Nonnull.class : Nullable.class);
        }
        if (!(comments = selection.getComments()).isEmpty()) {
            for (Comment comment : comments) {
                field.addJavadoc(this.asJavadoc(comment.getContent()), new Object[0]);
            }
        }
        builder.addField(field.build());
        MethodSpec.Builder getter = MethodSpec.methodBuilder((String)((fieldType == TypeName.BOOLEAN ? "is" : "get") + NamingUtil.uppercaseFirstCharacter(name))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(fieldType).addStatement("return $N", new Object[]{name});
        if (!fieldType.isPrimitive()) {
            getter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? Nonnull.class : Nullable.class);
        }
        builder.addMethod(getter.build());
        ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)fieldType, (String)name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (!fieldType.isPrimitive()) {
            parameter.addAnnotation(GraphQLTypeUtil.isNonNull((GraphQLType)fieldDefinition.getType()) ? Nonnull.class : Nullable.class);
        }
        MethodSpec.Builder setter = MethodSpec.methodBuilder((String)("set" + NamingUtil.uppercaseFirstCharacter(name))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter.build()).addStatement("this.$N = $N", new Object[]{name, name});
        builder.addMethod(setter.build());
    }

    private void emitGraphQLError(@Nonnull GeneratorContext context) throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)GRAPH_QL_ERROR_TYPE_NAME);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.addType(this.buildErrorLocationType().build());
        builder.addField(FieldSpec.builder(String.class, (String)"message", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Nonnull.class).addStatement("return $T.requireNonNull( message )", new Object[]{Objects.class}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)"message", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build()).addStatement("this.message = $T.requireNonNull( message )", new Object[]{Objects.class}).build());
        ArrayTypeName type = Object[].class;
        builder.addField(FieldSpec.builder(type, (String)"path", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nullable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getPath").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(type).addAnnotation(Nullable.class).addStatement("return path", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setPath").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(type, (String)"path", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("this.path = path", new Object[0]).build());
        type = ArrayTypeName.of((TypeName)ClassName.bestGuess((String)"Location"));
        builder.addField(FieldSpec.builder((TypeName)type, (String)"locations", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nullable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getLocations").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)type).addAnnotation(Nullable.class).addStatement("return locations", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setLocations").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)type, (String)"locations", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("this.locations = locations", new Object[0]).build());
        type = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class});
        builder.addField(FieldSpec.builder((TypeName)type, (String)"extensions", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nullable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getExtensions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)type).addAnnotation(Nullable.class).addStatement("return extensions", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setExtensions").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)type, (String)"extensions", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("this.extensions = extensions", new Object[0]).build());
        JavaGenUtil.writeTopLevelType(context, builder);
    }

    @Nonnull
    private TypeSpec.Builder buildErrorLocationType() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Location");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        builder.addField(FieldSpec.builder(Integer.TYPE, (String)"line", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getLine").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return line", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setLine").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(Integer.TYPE, (String)"line", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this.line = line", new Object[0]).build());
        builder.addField(FieldSpec.builder(Integer.TYPE, (String)"column", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getColumn").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return column", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setColumn").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(Integer.TYPE, (String)"column", (Modifier[])new Modifier[]{Modifier.FINAL}).build()).addStatement("this.column = column", new Object[0]).build());
        return builder;
    }

    @Nonnull
    private TypeSpec.Builder buildVariableType(@Nonnull Map<GraphQLType, String> typeMap, @Nonnull OperationDefinition operation) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Variables");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        HashMap<VariableDefinition, TypeName> variableTypes = new HashMap<VariableDefinition, TypeName>();
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            variableTypes.put(variable, JavaGenUtil.getJavaType(typeMap, variable.getType()));
        }
        builder.addMethod(this.buildVariablesConstructor(operation, variableTypes));
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            builder.addField(this.buildVariableField(variable, variableTypes));
            builder.addMethod(this.buildVariableGetter(variable, variableTypes));
        }
        return builder;
    }

    @Nonnull
    private MethodSpec buildVariablesConstructor(@Nonnull OperationDefinition operation, @Nonnull Map<VariableDefinition, TypeName> variableTypes) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            TypeName javaType = variableTypes.get(variable);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)variable.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            boolean isNonnull = variable.getType() instanceof NonNullType;
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(isNonnull ? Nonnull.class : Nullable.class);
            }
            ctor.addParameter(parameter.build());
            if (isNonnull) {
                ctor.addStatement("this.$N = $T.requireNonNull( $N )", new Object[]{variable.getName(), Objects.class, variable.getName()});
                continue;
            }
            ctor.addStatement("this.$N = $N", new Object[]{variable.getName(), variable.getName()});
        }
        return ctor.build();
    }

    @Nonnull
    private FieldSpec buildVariableField(@Nonnull VariableDefinition variable, @Nonnull Map<VariableDefinition, TypeName> variableTypes) {
        TypeName javaType = variableTypes.get(variable);
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)javaType, (String)variable.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(variable.getType() instanceof NonNullType ? Nonnull.class : Nullable.class);
        }
        return builder.build();
    }

    @Nonnull
    private MethodSpec buildVariableGetter(@Nonnull VariableDefinition variable, @Nonnull Map<VariableDefinition, TypeName> variableTypes) {
        String name = variable.getName();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("get" + NamingUtil.uppercaseFirstCharacter(name)));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        TypeName javaType = variableTypes.get(variable);
        builder.returns(javaType);
        if (!javaType.isPrimitive()) {
            builder.addAnnotation(variable.getType() instanceof NonNullType ? Nonnull.class : Nullable.class);
        }
        builder.addStatement("return $N", new Object[]{name});
        return builder.build();
    }

    @Nonnull
    private TypeSpec.Builder buildQuestionType(@Nonnull Map<GraphQLType, String> typeMap, @Nonnull OperationDefinition operation) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Question");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        HashMap<VariableDefinition, TypeName> variableTypes = new HashMap<VariableDefinition, TypeName>();
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            variableTypes.put(variable, JavaGenUtil.getJavaType(typeMap, variable.getType()));
        }
        if (!variableTypes.isEmpty()) {
            ClassName variablesType = ClassName.bestGuess((String)"Variables");
            builder.addField(FieldSpec.builder((TypeName)variablesType, (String)"variables", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(Nonnull.class).build());
            builder.addMethod(this.buildQuestionConstructor(operation, variableTypes));
            builder.addMethod(MethodSpec.methodBuilder((String)"getVariables").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Nonnull.class).returns((TypeName)variablesType).addStatement("return variables", new Object[0]).build());
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"getQuery").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Nonnull.class).returns((TypeName)ClassName.get(String.class)).addStatement("return QUERY", new Object[0]).build());
        return builder;
    }

    @Nonnull
    private MethodSpec buildQuestionConstructor(@Nonnull OperationDefinition operation, @Nonnull Map<VariableDefinition, TypeName> variableTypes) {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addModifiers(new Modifier[]{Modifier.PUBLIC});
        StringBuilder sb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sb.append("this.$N = new Variables( ");
        params.add("variables");
        boolean first = true;
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            TypeName javaType = variableTypes.get(variable);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)variable.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            boolean isNonnull = variable.getType() instanceof NonNullType;
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(isNonnull ? Nonnull.class : Nullable.class);
            }
            ctor.addParameter(parameter.build());
            if (!first) {
                sb.append(", $N");
            } else {
                sb.append("$N");
                first = false;
            }
            params.add(variable.getName());
        }
        sb.append(" )");
        ctor.addStatement(sb.toString(), params.toArray());
        return ctor.build();
    }

    @Nonnull
    private TypeSpec.Builder buildAnswerType(@Nonnull OperationDefinition operation) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Answer");
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        String name = operation.getName();
        assert (null != name);
        ClassName type = ClassName.bestGuess((String)(NamingUtil.uppercaseFirstCharacter(name) + "Response"));
        builder.addField(FieldSpec.builder((TypeName)type, (String)"data", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nullable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"hasData").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return null != data", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getData").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Nonnull.class).returns((TypeName)type).addStatement("return $T.requireNonNull( data )", new Object[]{Objects.class}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setData").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)type, (String)"data", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("this.data = data", new Object[0]).build());
        ArrayTypeName type2 = ArrayTypeName.of((TypeName)ClassName.bestGuess((String)GRAPH_QL_ERROR_TYPE_NAME));
        builder.addField(FieldSpec.builder((TypeName)type2, (String)"errors", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nullable.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"hasErrors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addStatement("return null != errors", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getErrors").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Nonnull.class).returns((TypeName)type2).addStatement("return $T.requireNonNull( errors )", new Object[]{Objects.class}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"setErrors").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)type2, (String)"errors", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("this.errors = errors", new Object[0]).build());
        return builder;
    }
}

