/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator;

import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.realityforge.giggle.generator.GeneratorEntry;
import org.realityforge.giggle.generator.GlobalGeneratorContext;

public final class GeneratorContext {
    @Nonnull
    private final GeneratorEntry _generator;
    @Nonnull
    private final GlobalGeneratorContext _context;

    public GeneratorContext(@Nonnull GeneratorEntry generator, @Nonnull GlobalGeneratorContext context) {
        this._generator = Objects.requireNonNull(generator);
        this._context = Objects.requireNonNull(context);
    }

    @Nonnull
    public GraphQLSchema getSchema() {
        return this._context.getSchema();
    }

    @Nonnull
    public Document getDocument() {
        return this._context.getDocument();
    }

    @Nonnull
    public Map<String, String> getTypeMapping() {
        return this._context.getTypeMapping();
    }

    @Nonnull
    public Map<String, String> getFragmentMapping() {
        return this._context.getFragmentMapping();
    }

    @Nonnull
    public Path getOutputDirectory() {
        return this._context.getOutputDirectory();
    }

    @Nonnull
    public String getPackageName() {
        return this._context.getPackageName();
    }

    @Nonnull
    public String getRequiredProperty(@Nonnull String name) {
        if (!this._generator.getProperty(name).isRequired()) {
            String message = "Generator named '" + this._generator.getName() + "' attempted to access property named '" + name + "' as if it was required but declared the property as optional";
            throw new IllegalStateException(message);
        }
        String value = this._context.getDefines().get(name);
        if (null == value) {
            String message = "Generator named '" + this._generator.getName() + "' accessed required property named '" + name + "' but no such property was defined";
            throw new IllegalStateException(message);
        }
        return Objects.requireNonNull(value);
    }

    @Nullable
    public String getProperty(@Nonnull String name) {
        this._generator.getProperty(name);
        return this._context.getDefines().get(name);
    }
}

