/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.document;

import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.parser.Parser;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import graphql.validation.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import org.realityforge.giggle.document.DocumentReadException;
import org.realityforge.giggle.document.DocumentValidateException;
import org.realityforge.giggle.util.GraphQLUtil;

public final class DocumentRepository {
    @Nonnull
    private final Parser _parser = new Parser();
    @Nonnull
    private final Validator _validator = new Validator();

    @Nonnull
    public Document getDocument(@Nonnull GraphQLSchema schema, @Nonnull List<Path> components) throws DocumentReadException, DocumentValidateException {
        assert (!components.isEmpty());
        Document document = Document.newDocument().build();
        for (Path component : components) {
            document = document.transform(b -> this.mergeComponent((Document.Builder)b, component));
        }
        List errors = this._validator.validateDocument(schema, document);
        this.validateNoAnonymousOperations(document, errors);
        this.validateTopLevelFieldsMatchOperationType(schema, document, errors);
        if (errors.isEmpty()) {
            return document;
        }
        throw new DocumentValidateException(errors);
    }

    private void validateNoAnonymousOperations(@Nonnull Document document, @Nonnull List<ValidationError> errors) {
        document.getDefinitionsOfType(OperationDefinition.class).stream().filter(d -> null == d.getName()).findAny().ifPresent(definition -> errors.add(new ValidationError(ValidationErrorType.LoneAnonymousOperationViolation, definition.getSourceLocation(), "Giggle does not allow anonymous operations.")));
    }

    private void validateTopLevelFieldsMatchOperationType(@Nonnull GraphQLSchema schema, @Nonnull Document document, @Nonnull List<ValidationError> errors) {
        for (OperationDefinition definition : document.getDefinitionsOfType(OperationDefinition.class)) {
            SelectionSet selectionSet = definition.getSelectionSet();
            List fields = selectionSet.getSelectionsOfType(Field.class);
            for (Field field : fields) {
                String topLevelFieldName = GraphQLUtil.getTopLevelFieldName(definition.getOperation());
                GraphQLObjectType query = schema.getObjectType(topLevelFieldName);
                GraphQLFieldDefinition fieldDefinition = null == query ? null : query.getFieldDefinition(field.getName());
                if (null != fieldDefinition) continue;
                String message = String.format("Field '%s' of type '%s' is undefined", field.getName(), topLevelFieldName);
                errors.add(new ValidationError(ValidationErrorType.FieldUndefined, field.getSourceLocation(), message));
            }
        }
    }

    private void mergeComponent(@Nonnull Document.Builder builder, @Nonnull Path component) {
        this._parser.parseDocument(this.readDocument(component), component.toString()).getDefinitions().forEach(arg_0 -> ((Document.Builder)builder).definition(arg_0));
    }

    @Nonnull
    private String readDocument(@Nonnull Path component) {
        try {
            return new String(Files.readAllBytes(component), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new DocumentReadException("Error reading file " + component, ioe);
        }
    }
}

