/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.cdi_client;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import graphql.language.Definition;
import graphql.language.NonNullType;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.PropertyDef;
import org.realityforge.giggle.generator.java.AbstractJavaGenerator;
import org.realityforge.giggle.generator.java.JavaGenUtil;
import org.realityforge.giggle.generator.java.NamingUtil;
import org.realityforge.giggle.util.GraphQLUtil;

@Generator.MetaData(name="java-cdi-client")
public class JavaCdiClientGenerator
extends AbstractJavaGenerator {
    private static final String SERVICE_NAME_KEY = "cdi.service.name";
    private static final String BASE_URL_KEY = "cdi.base_url.jndi_name";
    private static final String CONNECT_TIMEOUT_KEY = "cdi.connect_timeout";
    private static final String READ_TIMEOUT_KEY = "cdi.read_timeout";
    private static final String URL_SUFFIX_KEY = "cdi.url.suffix";
    private static final String KEYCLOAK_CLIENT_NAME_KEY = "cdi.keycloak.client.name";
    private static final ClassName RESOURCE_TYPE = ClassName.get((String)"javax.annotation", (String)"Resource", (String[])new String[0]);
    private static final ClassName APPLICATION_SCOPED_TYPE = ClassName.get((String)"javax.enterprise.context", (String)"ApplicationScoped", (String[])new String[0]);
    private static final ClassName TRANSACTIONAL_TYPE = ClassName.get((String)"javax.transaction", (String)"Transactional", (String[])new String[0]);
    private static final ClassName INJECT_TYPE = ClassName.get((String)"javax.inject", (String)"Inject", (String[])new String[0]);
    private static final ClassName NAMED_TYPE = ClassName.get((String)"javax.inject", (String)"Named", (String[])new String[0]);
    private static final ClassName TYPED_TYPE = ClassName.get((String)"javax.enterprise.inject", (String)"Typed", (String[])new String[0]);
    private static final ClassName RESPONSE_TYPE = ClassName.get((String)"javax.ws.rs.core", (String)"Response", (String[])new String[0]);
    private static final ClassName MEDIA_TYPE_TYPE = ClassName.get((String)"javax.ws.rs.core", (String)"MediaType", (String[])new String[0]);
    private static final ClassName CLIENT_BUILDER_TYPE = ClassName.get((String)"javax.ws.rs.client", (String)"ClientBuilder", (String[])new String[0]);
    private static final ClassName INVOCATION_BUILDER_TYPE = ClassName.get((String)"javax.ws.rs.client", (String)"Invocation", (String[])new String[]{"Builder"});
    private static final ClassName ENTITY_TYPE = ClassName.get((String)"javax.ws.rs.client", (String)"Entity", (String[])new String[0]);
    private static final ClassName KEYCLOAK_TYPE = ClassName.get((String)"org.realityforge.keycloak.client.authfilter", (String)"Keycloak", (String[])new String[0]);

    @Override
    @Nonnull
    public List<PropertyDef> getSupportedProperties() {
        ArrayList<PropertyDef> properties = new ArrayList<PropertyDef>();
        properties.add(new PropertyDef(SERVICE_NAME_KEY, true, "The name of the generated service class"));
        properties.add(new PropertyDef(BASE_URL_KEY, true, "The name of the JNDI resource that contains the base url for the endpoint"));
        properties.add(new PropertyDef(URL_SUFFIX_KEY, false, "The path added to the setting retrieved from the base_url.config.key to construct the url. If unspecified then no suffix is added"));
        properties.add(new PropertyDef(CONNECT_TIMEOUT_KEY, false, "The timeout in milliseconds after which a connect will fail. If unspecified then it defaults to 10s"));
        properties.add(new PropertyDef(READ_TIMEOUT_KEY, false, "The timeout in milliseconds after which a read will fail. If unspecified then it defaults to 10s"));
        properties.add(new PropertyDef(KEYCLOAK_CLIENT_NAME_KEY, false, "The name of the keycloak client used to authenticate the client. If unspecified then it is assumed no authentication step"));
        return properties;
    }

    @Override
    public void generate(@Nonnull GeneratorContext context) throws Exception {
        Map<GraphQLNamedType, String> typeMap = this.buildTypeMapping(context);
        List<GraphQLType> types = this.extractTypesToGenerate(context.getSchema(), typeMap);
        typeMap.putAll(this.extractGeneratedDataTypes(context, types));
        String serviceName = context.getRequiredProperty(SERVICE_NAME_KEY);
        JavaGenUtil.writeTopLevelType(context, this.emitServiceInterface(context, serviceName, typeMap));
        JavaGenUtil.writeTopLevelType(context, this.emitServiceImplementation(context, serviceName, typeMap));
    }

    @Nonnull
    private TypeSpec.Builder emitServiceImplementation(@Nonnull GeneratorContext context, @Nonnull String serviceName, @Nonnull Map<GraphQLNamedType, String> typeMap) {
        boolean keycloakEnabled;
        String baseUrlKey = context.getRequiredProperty(BASE_URL_KEY);
        ClassName self = ClassName.get((String)context.getPackageName(), (String)(serviceName + "Impl"), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)self);
        ClassName serviceType = ClassName.get((String)context.getPackageName(), (String)serviceName, (String[])new String[0]);
        builder.addSuperinterface((TypeName)serviceType);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addAnnotation(APPLICATION_SCOPED_TYPE);
        builder.addAnnotation(AnnotationSpec.builder((ClassName)TRANSACTIONAL_TYPE).addMember("value", "$T.TxType.NOT_SUPPORTED", new Object[]{TRANSACTIONAL_TYPE}).build());
        builder.addAnnotation(AnnotationSpec.builder((ClassName)TYPED_TYPE).addMember("value", "$T.class", new Object[]{serviceType}).build());
        for (Definition definition : context.getDocument().getDefinitions()) {
            OperationDefinition operation;
            if (!(definition instanceof OperationDefinition) || OperationDefinition.Operation.SUBSCRIPTION == (operation = (OperationDefinition)definition).getOperation()) continue;
            builder.addMethod(this.buildOperationMethodImplementation(context, typeMap, operation));
        }
        builder.addField(FieldSpec.builder(String.class, (String)"baseUrl", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nonnull.class).addAnnotation(AnnotationSpec.builder((ClassName)RESOURCE_TYPE).addMember("lookup", "$S", new Object[]{baseUrlKey}).build()).build());
        String keycloakClientName = context.getProperty(KEYCLOAK_CLIENT_NAME_KEY);
        if (null != keycloakClientName) {
            builder.addField(FieldSpec.builder((TypeName)KEYCLOAK_TYPE, (String)"keycloak", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nonnull.class).addAnnotation(AnnotationSpec.builder((ClassName)NAMED_TYPE).addMember("value", "$S", new Object[]{keycloakClientName}).build()).addAnnotation(INJECT_TYPE).build());
        }
        builder.addMethod(this.buildCallMethod(context));
        boolean bl = keycloakEnabled = null != context.getProperty(KEYCLOAK_CLIENT_NAME_KEY);
        if (keycloakEnabled) {
            builder.addMethod(this.buildGetTokenMethod(context));
        }
        return builder;
    }

    @Nonnull
    private MethodSpec buildGetTokenMethod(@Nonnull GeneratorContext context) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"$giggle$_getBearerToken").addAnnotation(Nonnull.class).returns(String.class);
        method.addStatement("final $T token = this.keycloak.getAccessToken()", new Object[]{String.class});
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if( null == token )", new Object[0]);
        block.addStatement("throw new $T( $S )", new Object[]{this.getGraphQLExceptionClassName(context), "Bearer token unavailable from Keycloak"});
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("return token", new Object[0]);
        return method.build();
    }

    @Nonnull
    private ClassName getGraphQLExceptionClassName(@Nonnull GeneratorContext context) {
        String exceptionType = context.getTypeMapping().get("GraphQLException");
        return ClassName.bestGuess((String)(null != exceptionType ? exceptionType : "GraphQLException"));
    }

    @Nonnull
    private MethodSpec buildCallMethod(@Nonnull GeneratorContext context) {
        TypeVariableName typeVariable = TypeVariableName.get((String)"T");
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"$giggle$_call").addTypeVariable(typeVariable).addAnnotation(Nonnull.class).addParameter(ParameterSpec.builder((TypeName)typeVariable, (String)"entity", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class).build()).returns((TypeName)RESPONSE_TYPE);
        String urlSuffix = context.getProperty(URL_SUFFIX_KEY);
        if (null == urlSuffix) {
            method.addStatement("final $T uri = $T.create( this.baseUrl )", new Object[]{URI.class, URI.class});
        } else {
            method.addStatement("final $T uri = $T.create( this.baseUrl + $S )", new Object[]{URI.class, URI.class, urlSuffix});
        }
        method.addStatement("$T request = $T.newClient().target( uri ).request()", new Object[]{INVOCATION_BUILDER_TYPE, CLIENT_BUILDER_TYPE});
        method.addStatement("request = request.accept( $T.APPLICATION_JSON_TYPE )", new Object[]{MEDIA_TYPE_TYPE});
        method.addStatement("request = request.property( $S, $L )", new Object[]{"jersey.config.client.connectTimeout", this.getTimeout(context, CONNECT_TIMEOUT_KEY)});
        method.addStatement("request = request.property( $S, $L )", new Object[]{"jersey.config.client.readTimeout", this.getTimeout(context, READ_TIMEOUT_KEY)});
        if (null != context.getProperty(KEYCLOAK_CLIENT_NAME_KEY)) {
            method.addStatement("request = request.header( \"Authorization\", \"bearer \" + $N() )", new Object[]{"$giggle$_getBearerToken"});
        }
        method.addStatement("return request.post( $T.json( entity ) )", new Object[]{ENTITY_TYPE});
        return method.build();
    }

    private long getTimeout(@Nonnull GeneratorContext context, @Nonnull String key) {
        String value = context.getProperty(key);
        if (null == value) {
            return TimeUnit.SECONDS.toMillis(10L);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            String message = "Failed to parse configuration property " + key + " with value '" + value + "' due to " + e;
            throw new IllegalStateException(message);
        }
    }

    @Nonnull
    private MethodSpec buildOperationMethodImplementation(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLNamedType, String> typeMap, @Nonnull OperationDefinition operation) {
        Map<VariableDefinition, TypeName> variableTypes = this.buildVariableMap(operation, typeMap);
        String typeName = this.toOperationClassName(operation);
        String name = operation.getName();
        assert (null != name);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)NamingUtil.lowercaseFirstCharacter(name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(Nonnull.class).returns((TypeName)ClassName.get((String)context.getPackageName(), (String)typeName, (String[])new String[]{"Answer"}));
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        sb.append("try ( $T response = $N( new $T(");
        params.add(RESPONSE_TYPE);
        params.add("$giggle$_call");
        params.add(ClassName.get((String)context.getPackageName(), (String)typeName, (String[])new String[]{"Question"}));
        boolean first = true;
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            TypeName javaType = variableTypes.get(variable);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)variable.getName(), (Modifier[])new Modifier[]{Modifier.FINAL});
            boolean isNonnull = variable.getType() instanceof NonNullType;
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(isNonnull ? Nonnull.class : Nullable.class);
            }
            method.addParameter(parameter.build());
            if (first) {
                sb.append(" ");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("$N");
            params.add(variable.getName());
        }
        if (!first) {
            sb.append(" ");
        }
        sb.append(") ) )");
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow(sb.toString(), params.toArray());
        CodeBlock.Builder body = CodeBlock.builder();
        body.beginControlFlow("if( $T.Status.Family.SUCCESSFUL == response.getStatusInfo().getFamily() )", new Object[]{RESPONSE_TYPE});
        body.addStatement("return response.readEntity( $T.class )", new Object[]{ClassName.get((String)context.getPackageName(), (String)typeName, (String[])new String[]{"Answer"})});
        body.nextControlFlow("else", new Object[0]);
        body.addStatement("throw new $T( $S + response.getStatusInfo() )", new Object[]{this.getGraphQLExceptionClassName(context), "Error invoking GraphQL endpoint. HTTP Status: "});
        body.endControlFlow();
        code.add(body.build());
        code.endControlFlow();
        method.addCode(code.build());
        return method.build();
    }

    @Nonnull
    private TypeSpec.Builder emitServiceInterface(@Nonnull GeneratorContext context, @Nonnull String serviceName, @Nonnull Map<GraphQLNamedType, String> typeMap) {
        ClassName self = ClassName.get((String)context.getPackageName(), (String)serviceName, (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)self);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Definition definition : context.getDocument().getDefinitions()) {
            OperationDefinition operation;
            if (!(definition instanceof OperationDefinition) || OperationDefinition.Operation.SUBSCRIPTION == (operation = (OperationDefinition)definition).getOperation()) continue;
            builder.addMethod(this.buildOperationMethod(context, typeMap, operation));
        }
        return builder;
    }

    @Nonnull
    private MethodSpec buildOperationMethod(@Nonnull GeneratorContext context, @Nonnull Map<GraphQLNamedType, String> typeMap, @Nonnull OperationDefinition operation) {
        Map<VariableDefinition, TypeName> variableTypes = this.buildVariableMap(operation, typeMap);
        String typeName = this.toOperationClassName(operation);
        String name = operation.getName();
        assert (null != name);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)NamingUtil.lowercaseFirstCharacter(name)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Nonnull.class).returns((TypeName)ClassName.get((String)context.getPackageName(), (String)typeName, (String[])new String[]{"Answer"}));
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            TypeName javaType = variableTypes.get(variable);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)javaType, (String)variable.getName(), (Modifier[])new Modifier[0]);
            boolean isNonnull = variable.getType() instanceof NonNullType;
            if (!javaType.isPrimitive()) {
                parameter.addAnnotation(isNonnull ? Nonnull.class : Nullable.class);
            }
            method.addParameter(parameter.build());
        }
        return method.build();
    }

    @Nonnull
    private Map<VariableDefinition, TypeName> buildVariableMap(@Nonnull OperationDefinition operation, @Nonnull Map<GraphQLNamedType, String> typeMap) {
        HashMap<VariableDefinition, TypeName> variableTypes = new HashMap<VariableDefinition, TypeName>();
        for (VariableDefinition variable : operation.getVariableDefinitions()) {
            variableTypes.put(variable, JavaGenUtil.getJavaType(typeMap, variable.getType()));
        }
        return variableTypes;
    }

    @Nonnull
    private String toOperationClassName(@Nonnull OperationDefinition operation) {
        String name = operation.getName();
        assert (null != name);
        OperationDefinition.Operation operationType = operation.getOperation();
        return NamingUtil.uppercaseFirstCharacter(name) + GraphQLUtil.getTopLevelFieldName(operationType);
    }
}

