/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import graphql.Scalars;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nonnull;

final class ScalarTypeRegistry {
    @Nonnull
    private final Map<String, TypeName> _typeMap = new HashMap<String, TypeName>();

    @Nonnull
    static ScalarTypeRegistry createDefault() {
        ScalarTypeRegistry registry = new ScalarTypeRegistry();
        registry.registerType(Scalars.GraphQLBoolean.getName(), TypeName.BOOLEAN);
        registry.registerType(Scalars.GraphQLByte.getName(), TypeName.BYTE);
        registry.registerType(Scalars.GraphQLShort.getName(), TypeName.SHORT);
        registry.registerType(Scalars.GraphQLInt.getName(), TypeName.INT);
        registry.registerType(Scalars.GraphQLLong.getName(), TypeName.LONG);
        registry.registerType(Scalars.GraphQLChar.getName(), TypeName.CHAR);
        registry.registerType(Scalars.GraphQLFloat.getName(), TypeName.FLOAT);
        registry.registerType(Scalars.GraphQLID.getName(), (TypeName)ClassName.get(String.class));
        registry.registerType(Scalars.GraphQLString.getName(), (TypeName)ClassName.get(String.class));
        registry.registerType(Scalars.GraphQLBigDecimal.getName(), (TypeName)ClassName.get(BigDecimal.class));
        registry.registerType(Scalars.GraphQLBigInteger.getName(), (TypeName)ClassName.get(BigInteger.class));
        registry.registerType("TimeZone", (TypeName)ClassName.get(TimeZone.class));
        registry.registerType("Instant", (TypeName)ClassName.get(Instant.class));
        registry.registerType("Duration", (TypeName)ClassName.get(Duration.class));
        registry.registerType("Period", (TypeName)ClassName.get(Period.class));
        registry.registerType("LocalDate", (TypeName)ClassName.get(LocalDate.class));
        registry.registerType("LocalTime", (TypeName)ClassName.get(LocalTime.class));
        registry.registerType("LocalDateTime", (TypeName)ClassName.get(LocalDateTime.class));
        registry.registerType("ZonedDateTime", (TypeName)ClassName.get(ZonedDateTime.class));
        registry.registerType("ZoneId", (TypeName)ClassName.get(ZoneId.class));
        registry.registerType("ZoneOffset", (TypeName)ClassName.get(ZoneOffset.class));
        registry.registerType("OffsetDateTime", (TypeName)ClassName.get(OffsetDateTime.class));
        registry.registerType("OffsetTime", (TypeName)ClassName.get(OffsetTime.class));
        return registry;
    }

    ScalarTypeRegistry() {
    }

    boolean isRegistered(@Nonnull String name) {
        return this._typeMap.containsKey(name);
    }

    void registerType(@Nonnull String name, @Nonnull TypeName type) {
        this._typeMap.put(name, type);
    }

    @Nonnull
    TypeName getType(@Nonnull String name) {
        TypeName typeName = this._typeMap.get(name);
        if (null == typeName) {
            throw new IllegalStateException("Unknown scalar type named '" + name + "'");
        }
        return typeName;
    }
}

