/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle;

import graphql.GraphQLError;
import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.validation.ValidationError;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.realityforge.getopt4j.CLArgsParser;
import org.realityforge.getopt4j.CLOption;
import org.realityforge.getopt4j.CLOptionDescriptor;
import org.realityforge.getopt4j.CLUtil;
import org.realityforge.giggle.Environment;
import org.realityforge.giggle.RawFormatter;
import org.realityforge.giggle.TerminalStateException;
import org.realityforge.giggle.document.DocumentReadException;
import org.realityforge.giggle.document.DocumentRepository;
import org.realityforge.giggle.document.DocumentValidateException;
import org.realityforge.giggle.generator.GenerateException;
import org.realityforge.giggle.generator.GeneratorEntry;
import org.realityforge.giggle.generator.GeneratorRepository;
import org.realityforge.giggle.generator.GlobalGeneratorContext;
import org.realityforge.giggle.generator.NoSuchGeneratorException;
import org.realityforge.giggle.generator.PropertyDef;
import org.realityforge.giggle.schema.SchemaReadException;
import org.realityforge.giggle.schema.SchemaRepository;
import org.realityforge.giggle.util.IoUtil;
import org.realityforge.giggle.util.MappingUtil;

public class Main {
    private static final int HELP_OPT = 104;
    private static final int QUIET_OPT = 113;
    private static final int VERBOSE_OPT = 118;
    private static final int DEFINE_OPT = 68;
    private static final int SCHEMA_FILE_OPT = 1;
    private static final int DOCUMENT_FILE_OPT = 2;
    private static final int TYPE_MAPPING_FILE_OPT = 3;
    private static final int FRAGMENT_MAPPING_FILE_OPT = 4;
    private static final int OUTPUT_DIRECTORY_OPT = 6;
    private static final int PACKAGE_NAME_OPT = 7;
    private static final int GENERATOR_OPT = 8;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print this message and exit"), new CLOptionDescriptor("quiet", 8, 113, "Do not output unless an error occurs.", new int[]{118}), new CLOptionDescriptor("verbose", 8, 118, "Verbose output of differences.", new int[]{113}), new CLOptionDescriptor("schema", 34, 1, "The path to a graphql schema file."), new CLOptionDescriptor("document", 34, 2, "The path to a graphql document file."), new CLOptionDescriptor("type-mapping", 34, 3, "The path to a mapping file for types."), new CLOptionDescriptor("fragment-mapping", 34, 4, "The path to a mapping file for fragments."), new CLOptionDescriptor("define", 48, 68, "Define a property used by the generators."), new CLOptionDescriptor("package", 2, 7, "The java package name used to generate artifacts."), new CLOptionDescriptor("output-directory", 2, 6, "The directory where generated files are output."), new CLOptionDescriptor("generator", 34, 8, "The name of a generator to run on the model.")};

    public static void main(String[] args) {
        System.exit(Main.run(new Environment(Paths.get("", new String[0]).toAbsolutePath(), Logger.getGlobal()), args));
    }

    private static int run(@Nonnull Environment environment, @Nonnull String[] args) {
        Main.setupLogger(environment);
        if (!Main.processOptions(environment, args)) {
            return 2;
        }
        Logger logger = environment.logger();
        try {
            SchemaRepository schemaRepository = new SchemaRepository();
            GraphQLSchema schema = schemaRepository.getSchema(environment.getSchemaFiles());
            DocumentRepository documentRepository = new DocumentRepository();
            Document document = documentRepository.getDocument(schema, environment.getDocumentFiles());
            Map<String, String> typeMapping = MappingUtil.getMapping(environment.getTypeMappingFiles());
            Map<String, String> fragmentMapping = MappingUtil.getMapping(environment.getFragmentMappingFiles());
            List<String> generators = environment.getGenerators();
            if (!generators.isEmpty()) {
                IoUtil.deleteDirIfExists(environment.getOutputDirectory());
                GlobalGeneratorContext context = new GlobalGeneratorContext(schema, document, typeMapping, fragmentMapping, environment.getDefines(), environment.getOutputDirectory(), environment.getPackageName());
                Main.verifyTypeMapping(context);
                for (String generator : generators) {
                    environment.getGeneratorRepository().getGenerator(generator).generate(context);
                }
            }
        }
        catch (GenerateException ge) {
            logger.log(Level.WARNING, "Error: Failed generating artifacts using generator named " + ge.getName(), ge.getCause());
            return 7;
        }
        catch (NoSuchGeneratorException nsge) {
            logger.log(Level.WARNING, "Error: Unable to locate generator named " + nsge.getName());
            return 7;
        }
        catch (DocumentReadException dre) {
            logger.log(Level.WARNING, dre.getMessage());
            return 5;
        }
        catch (DocumentValidateException dve) {
            logger.log(Level.WARNING, "Error: Failed to validate document");
            List<ValidationError> errors = dve.getErrors();
            for (ValidationError error : errors) {
                String locations = error.getLocations().stream().map(e -> e.getSourceName() + ":" + e.getLine()).collect(Collectors.joining(" "));
                logger.log(Level.WARNING, error.getErrorType() + ":" + error.getMessage() + (locations.isEmpty() ? "" : " @ " + locations));
            }
            return 6;
        }
        catch (SchemaReadException sre) {
            logger.log(Level.WARNING, sre.getMessage());
            return 3;
        }
        catch (SchemaProblem sp) {
            logger.log(Level.WARNING, "Error: Failed to parse schema");
            List errors = sp.getErrors();
            for (GraphQLError error : errors) {
                String locations = error.getLocations().stream().map(e -> e.getSourceName() + ":" + e.getLine()).collect(Collectors.joining(" "));
                logger.log(Level.WARNING, error.getErrorType() + ":" + error.getMessage() + (locations.isEmpty() ? "" : " @ " + locations));
            }
            return 4;
        }
        catch (TerminalStateException tse) {
            String message = tse.getMessage();
            if (null != message) {
                logger.log(Level.WARNING, message);
                Throwable cause = tse.getCause();
                if (null != cause && logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Cause: " + cause.toString());
                    if (logger.isLoggable(Level.FINE)) {
                        cause.printStackTrace();
                    }
                }
            }
            return tse.getExitCode();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, t.toString(), t);
            return 1;
        }
        return 0;
    }

    static void verifyTypeMapping(@Nonnull GlobalGeneratorContext context) {
        GraphQLSchema schema = context.getSchema();
        for (Map.Entry<String, String> entry : context.getTypeMapping().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (null != schema.getType(key)) continue;
            throw new TerminalStateException("Type mapping attempted to map the type named '" + key + "' to " + value + " but there is no type named '" + key + "'", 8);
        }
    }

    private static void setupLogger(@Nonnull Environment environment) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new RawFormatter());
        handler.setLevel(Level.ALL);
        Logger logger = environment.logger();
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        logger.setLevel(Level.INFO);
    }

    static boolean processOptions(@Nonnull Environment environment, String ... args) {
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        Logger logger = environment.logger();
        if (null != parser.getErrorString()) {
            logger.log(Level.SEVERE, "Error: " + parser.getErrorString());
            return false;
        }
        List options = parser.getArguments();
        for (CLOption option : options) {
            switch (option.getId()) {
                case 0: {
                    logger.log(Level.SEVERE, "Error: Unknown argument: " + option.getArgument());
                    return false;
                }
                case 1: {
                    if (!Main.fileArgument(environment, option, "schema", environment::addSchemaFile)) break;
                    return false;
                }
                case 2: {
                    if (!Main.fileArgument(environment, option, "document", environment::addDocumentFile)) break;
                    return false;
                }
                case 3: {
                    if (!Main.fileArgument(environment, option, "type mapping", environment::addTypeMappingFile)) break;
                    return false;
                }
                case 4: {
                    if (!Main.fileArgument(environment, option, "fragment mapping", environment::addFragmentMappingFile)) break;
                    return false;
                }
                case 68: {
                    String key = option.getArgument(0);
                    String value = option.getArgument(1);
                    if (environment.getDefines().containsKey(key)) {
                        logger.log(Level.SEVERE, "Error: Duplicate property defined specified: " + key);
                        return false;
                    }
                    environment.addDefine(key, value);
                    break;
                }
                case 6: {
                    String argument = option.getArgument();
                    Path dir = environment.currentDirectory().resolve(argument).toAbsolutePath().normalize();
                    if (dir.toFile().exists() && !dir.toFile().isDirectory()) {
                        String message = "Error: Specified output directory exists and is not a directory. Specified value: " + argument;
                        logger.log(Level.SEVERE, message);
                        return false;
                    }
                    environment.setOutputDirectory(dir);
                    break;
                }
                case 8: {
                    String argument = option.getArgument();
                    if (environment.getGenerators().contains(argument)) {
                        logger.log(Level.SEVERE, "Error: Duplicate generators specified: " + argument);
                        return false;
                    }
                    environment.addGenerator(argument);
                    break;
                }
                case 7: {
                    environment.setPackageName(option.getArgument());
                    break;
                }
                case 118: {
                    logger.setLevel(Level.ALL);
                    break;
                }
                case 113: {
                    logger.setLevel(Level.WARNING);
                    break;
                }
                case 104: {
                    Main.printUsage(environment);
                    return false;
                }
            }
        }
        if (environment.getSchemaFiles().isEmpty()) {
            logger.log(Level.SEVERE, "Error: No schema files specified.");
            return false;
        }
        if (!environment.hasOutputDirectory() && !environment.getGenerators().isEmpty()) {
            logger.log(Level.SEVERE, "Error: Must specify output directory if a generator is specified.");
            return false;
        }
        if (!environment.hasPackageName()) {
            logger.log(Level.SEVERE, "Error: Must specify output package name.");
            return false;
        }
        if (!Main.verifyDefines(environment)) {
            return false;
        }
        Main.printBanner(environment);
        return true;
    }

    private static boolean verifyDefines(@Nonnull Environment environment) {
        GeneratorRepository repository = environment.getGeneratorRepository();
        Set<String> generatorNames = repository.getGeneratorNames();
        Map<String, String> defines = environment.getDefines();
        if (!defines.isEmpty()) {
            for (String propertyKey : defines.keySet()) {
                boolean propertyMatched = false;
                for (String generatorName : generatorNames) {
                    GeneratorEntry generator = repository.getGenerator(generatorName);
                    if (!generator.getSupportedProperties().containsKey(propertyKey)) continue;
                    propertyMatched = true;
                    break;
                }
                if (propertyMatched) continue;
                String message = "Error: Property defined with name '" + propertyKey + "' is not used by any generator.";
                environment.logger().log(Level.SEVERE, message);
                return false;
            }
        }
        for (String generatorName : environment.getGenerators()) {
            GeneratorEntry generator = repository.getGenerator(generatorName);
            for (PropertyDef property : generator.getSupportedProperties().values()) {
                if (!property.isRequired() || defines.containsKey(property.getKey())) continue;
                String message = "Error: Property named '" + property.getKey() + "' is required by the generator named '" + generatorName + "' but has not been defined.";
                environment.logger().log(Level.SEVERE, message);
                return false;
            }
        }
        return true;
    }

    static void printBanner(@Nonnull Environment environment) {
        Logger logger = environment.logger();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Giggle Starting...");
            logger.log(Level.FINE, "  Output directory: " + environment.getOutputDirectory());
            logger.log(Level.FINE, "  Output Package: " + environment.getPackageName());
            logger.log(Level.FINE, "  Generators: " + environment.getGenerators());
            logger.log(Level.FINE, "  Schema files: " + environment.getSchemaFiles());
            logger.log(Level.FINE, "  Document files: " + environment.getDocumentFiles());
            logger.log(Level.FINE, "  Type mapping files: " + environment.getTypeMappingFiles());
            logger.log(Level.FINE, "  Fragment mapping files: " + environment.getTypeMappingFiles());
            Map<String, String> defines = environment.getDefines();
            if (!defines.isEmpty()) {
                logger.log(Level.FINE, "  Property Defines:");
                for (Map.Entry<String, String> property : defines.entrySet()) {
                    logger.log(Level.FINE, "    " + property.getKey() + "=" + property.getValue());
                }
            }
        }
    }

    private static boolean fileArgument(@Nonnull Environment environment, @Nonnull CLOption option, @Nonnull String label, @Nonnull Consumer<Path> action) {
        String argument = option.getArgument();
        Path file = environment.currentDirectory().resolve(argument).toAbsolutePath().normalize();
        if (!file.toFile().exists()) {
            String message = "Error: Specified graphql " + label + " file does not exist. Specified value: " + argument;
            environment.logger().log(Level.SEVERE, message);
            return true;
        }
        action.accept(file);
        return false;
    }

    static void printUsage(@Nonnull Environment environment) {
        String[] options;
        Logger logger = environment.logger();
        logger.info("java " + Main.class.getName() + " [options]");
        logger.info("");
        logger.info("Options:");
        for (String line : options = CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS).toString().replace("\t", "  ").split(System.getProperty("line.separator"))) {
            logger.info(line);
        }
        GeneratorRepository repository = environment.getGeneratorRepository();
        logger.info("");
        logger.info("Supported Generators:");
        for (String generatorName : repository.getGeneratorNames()) {
            GeneratorEntry generator = repository.getGenerator(generatorName);
            logger.info("  " + generatorName);
            Collection<PropertyDef> properties = generator.getSupportedProperties().values();
            if (properties.isEmpty()) continue;
            logger.info("   Supported Properties:");
            for (PropertyDef property : properties) {
                logger.info("   - " + property.getKey() + (property.isRequired() ? " (required)" : "") + ": " + property.getDescription());
            }
        }
    }
}

