/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import graphql.Scalars;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.GeneratorContext;
import org.realityforge.giggle.generator.java.ScalarTypeRegistry;

public final class JavaGenUtil {
    @Nonnull
    private static final ScalarTypeRegistry c_scalarTypeRegistry = ScalarTypeRegistry.createDefault();

    private JavaGenUtil() {
    }

    public static void writeTopLevelType(@Nonnull GeneratorContext context, @Nonnull TypeSpec.Builder builder) throws IOException {
        JavaGenUtil.writeGeneratedAnnotation(builder);
        JavaFile.builder((String)context.getPackageName(), (TypeSpec)builder.build()).skipJavaLangImports(true).build().writeTo(context.getOutputDirectory());
    }

    private static void writeGeneratedAnnotation(@Nonnull TypeSpec.Builder builder) {
        Class<?> generated;
        try {
            generated = Class.forName("javax.annotation.processing.Generated");
        }
        catch (ClassNotFoundException ignored) {
            try {
                generated = Class.forName("javax.annotation.Generated");
            }
            catch (ClassNotFoundException ignored2) {
                return;
            }
        }
        builder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(generated)).addMember("value", "$S", new Object[]{"org.realityforge.giggle.Main"}).build());
    }

    @Nonnull
    public static TypeName getJavaType(@Nonnull Map<GraphQLNamedType, String> typeMap, @Nonnull Type<?> varType) {
        Type type = varType;
        boolean isNonNull = false;
        boolean isList = false;
        if (type instanceof NonNullType) {
            isNonNull = true;
            type = ((NonNullType)type).getType();
        }
        if (type instanceof ListType) {
            isList = true;
            if ((type = ((ListType)type).getType()) instanceof NonNullType) {
                type = ((NonNullType)type).getType();
            }
        }
        graphql.language.TypeName typeName = (graphql.language.TypeName)type;
        String name = typeMap.entrySet().stream().filter(e -> ((GraphQLNamedType)e.getKey()).getName().equals(typeName.getName())).findAny().map(Map.Entry::getValue).orElse(null);
        if (null != name) {
            return JavaGenUtil.wrap(isList, isNonNull, (TypeName)ClassName.bestGuess((String)name));
        }
        return JavaGenUtil.getScalarJavaType(isList, isNonNull, typeName.getName());
    }

    @Nonnull
    public static TypeName getJavaType(@Nonnull Map<GraphQLNamedType, String> typeMap, @Nonnull GraphQLDirectiveContainer container, @Nonnull GraphQLType specifiedType) {
        GraphQLType valueType = JavaGenUtil.getValueType(specifiedType);
        GraphQLUnmodifiedType type = GraphQLTypeUtil.unwrapAll((GraphQLType)valueType);
        String typeName = typeMap.get(type);
        if (null != typeName) {
            return JavaGenUtil.wrap(JavaGenUtil.isList(valueType), GraphQLTypeUtil.isNonNull((GraphQLType)valueType), (TypeName)ClassName.bestGuess((String)typeName));
        }
        return JavaGenUtil.getScalarJavaType(container, JavaGenUtil.isList(valueType), GraphQLTypeUtil.isNonNull((GraphQLType)valueType), (GraphQLNamedType)type);
    }

    @Nonnull
    private static GraphQLType getValueType(@Nonnull GraphQLType type) {
        return type instanceof GraphQLInputObjectField ? ((GraphQLInputObjectField)type).getType() : (type instanceof GraphQLArgument ? ((GraphQLArgument)type).getType() : (type instanceof GraphQLFieldDefinition ? ((GraphQLFieldDefinition)type).getType() : type));
    }

    @Nonnull
    private static TypeName getScalarJavaType(@Nonnull GraphQLDirectiveContainer container, boolean isList, boolean isNonnull, @Nonnull GraphQLNamedType type) {
        if (Scalars.GraphQLID.equals(type) && JavaGenUtil.hasNumericDirective(container)) {
            return JavaGenUtil.wrap(isList, isNonnull, TypeName.INT);
        }
        return JavaGenUtil.getScalarJavaType(isList, isNonnull, type);
    }

    @Nonnull
    private static TypeName getScalarJavaType(boolean isList, boolean isNonnull, @Nonnull GraphQLNamedType type) {
        return JavaGenUtil.getScalarJavaType(isList, isNonnull, type.getName());
    }

    @Nonnull
    private static TypeName getScalarJavaType(boolean isList, boolean isNonnull, @Nonnull String type) {
        return JavaGenUtil.wrap(isList, isNonnull, c_scalarTypeRegistry.getType(type));
    }

    @Nonnull
    private static TypeName wrap(boolean isList, boolean isNonnull, @Nonnull TypeName type) {
        boolean primitive = type.isPrimitive();
        return isList ? JavaGenUtil.listOf(primitive ? type.box() : type) : (primitive && !isNonnull ? type.box() : type);
    }

    @Nonnull
    public static TypeName listOf(@Nonnull TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{typeName});
    }

    public static boolean isList(@Nonnull GraphQLType type) {
        return GraphQLTypeUtil.isList((GraphQLType)type) || GraphQLTypeUtil.isWrapped((GraphQLType)type) && JavaGenUtil.isList(GraphQLTypeUtil.unwrapOne((GraphQLType)type));
    }

    public static boolean hasNumericDirective(@Nonnull GraphQLDirectiveContainer type) {
        return null != type.getDirective("numeric");
    }
}

