/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator.java.client;

import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class FieldCollector {
    @Nonnull
    private final Map<String, FragmentDefinition> _fragmentsByName;

    FieldCollector(@Nonnull Document document) {
        this._fragmentsByName = document.getDefinitions().stream().filter(definition -> definition instanceof FragmentDefinition).map(definition -> (FragmentDefinition)definition).collect(Collectors.toMap(FragmentDefinition::getName, v -> v, (a, b) -> b));
    }

    MergedSelectionSet collectFields(SelectionSet ... selectionSets) {
        LinkedHashMap<String, MergedField> subFields = new LinkedHashMap<String, MergedField>();
        for (SelectionSet selectionSet : selectionSets) {
            this.collectFields(selectionSet, new ArrayList<String>(), subFields);
        }
        return MergedSelectionSet.newMergedSelectionSet().subFields(subFields).build();
    }

    private void collectFields(@Nonnull SelectionSet selectionSet, @Nonnull List<String> visitedFragments, @Nonnull Map<String, MergedField> fields) {
        for (Selection selection : selectionSet.getSelections()) {
            if (selection instanceof Field) {
                this.collectField(fields, (Field)selection);
                continue;
            }
            if (selection instanceof InlineFragment) {
                this.collectFields(((InlineFragment)selection).getSelectionSet(), visitedFragments, fields);
                continue;
            }
            assert (selection instanceof FragmentSpread);
            String name = ((FragmentSpread)selection).getName();
            if (visitedFragments.contains(name)) continue;
            visitedFragments.add(name);
            this.collectFields(this._fragmentsByName.get(name).getSelectionSet(), visitedFragments, fields);
        }
    }

    private void collectField(@Nonnull Map<String, MergedField> fields, @Nonnull Field field) {
        String alias = field.getAlias();
        String name = null != alias ? alias : field.getName();
        MergedField existing = fields.get(name);
        if (null != existing) {
            fields.put(name, existing.transform(builder -> builder.addField(field)));
        } else {
            fields.put(name, MergedField.newMergedField((Field)field).build());
        }
    }
}

