/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.giggle.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.realityforge.giggle.generator.Generator;
import org.realityforge.giggle.generator.GeneratorEntry;
import org.realityforge.giggle.generator.NoSuchGeneratorException;

public abstract class AbstractGeneratorRepository {
    private final Map<String, GeneratorEntry> _generators = new HashMap<String, GeneratorEntry>();

    @Nonnull
    public final GeneratorEntry getGenerator(@Nonnull String name) throws NoSuchGeneratorException {
        GeneratorEntry generator = this._generators.get(name);
        if (null == generator) {
            throw new NoSuchGeneratorException(name);
        }
        return generator;
    }

    @Nonnull
    public final Set<String> getGeneratorNames() {
        return this._generators.keySet();
    }

    public final void registerGenerator(@Nonnull Generator generator) {
        GeneratorEntry entry = new GeneratorEntry(generator);
        this._generators.put(entry.getName(), entry);
    }
}

