/*
 * Decompiled with CFR 0.152.
 */
package gir.test.util;

import gir.io.Exec;
import gir.io.FileUtil;
import gir.test.util.ThrowingConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.testng.Assert;

public final class TestUtil {
    public static final String DEFAULT_NAME = "Your Name";
    public static final String DEFAULT_EMAIL = "you@example.com";

    private TestUtil() {
    }

    @Nonnull
    public static File createTempDirectory() throws IOException {
        File file = File.createTempFile("gir", "test");
        Assert.assertTrue((boolean)file.delete());
        Assert.assertTrue((boolean)file.mkdirs());
        return file;
    }

    @Nonnull
    public static File createGitRepository(@Nonnull ThrowingConsumer<File> action) throws Exception {
        File directory = TestUtil.createTempDirectory();
        action.accept(directory);
        TestUtil.setupAsGitRepository(directory);
        return directory;
    }

    public static void assertCommitSubject(@Nonnull File repository, @Nonnull String subject) throws Exception {
        TestUtil.assertCommitAttribute(repository, "%s", subject);
    }

    public static void assertCommitAuthor(@Nonnull File repository, @Nonnull String author) throws Exception {
        TestUtil.assertCommitAttribute(repository, "%an", author);
    }

    public static void assertCommitEmail(@Nonnull File repository, @Nonnull String email) throws Exception {
        TestUtil.assertCommitAttribute(repository, "%ae", email);
    }

    public static void assertCommitAttribute(@Nonnull File repository, @Nonnull String formatKey, @Nonnull Pattern pattern) throws Exception {
        TestUtil.assertCommitAttribute(repository, formatKey, pattern, 0);
    }

    public static void assertCommitAttribute(@Nonnull File repository, @Nonnull String formatKey, @Nonnull String value) throws Exception {
        TestUtil.assertCommitAttribute(repository, formatKey, value, 0);
    }

    public static void assertCommitAttribute(@Nonnull File repository, @Nonnull String formatKey, @Nonnull String value, int commitIndex) throws Exception {
        TestUtil.assertCommitAttribute(repository, formatKey, Pattern.compile(Pattern.quote(value)), commitIndex);
    }

    public static void assertCommitAttribute(@Nonnull File repository, @Nonnull String formatKey, @Nonnull Pattern pattern, int commitIndex) throws Exception {
        FileUtil.inDirectory((Path)repository.toPath(), () -> {
            String[] lines = Exec.capture((String[])new String[]{"git", "log", "--pretty=format:" + formatKey}).split("\n");
            String line = lines[commitIndex];
            Assert.assertTrue((boolean)pattern.matcher(line).matches(), (String)("Pattern: " + pattern + " expected to match line: " + line));
        });
    }

    public static void setupAsGitRepository(@Nonnull File directory) throws Exception {
        TestUtil.setupAsGitRepository(directory, DEFAULT_NAME, DEFAULT_EMAIL);
    }

    public static void setupAsGitRepository(@Nonnull File directory, @Nonnull String name, @Nonnull String email) throws Exception {
        FileUtil.inDirectory((Path)directory.toPath(), () -> {
            Exec.system((String[])new String[]{"git", "init"});
            Exec.system((String[])new String[]{"git", "config", "--local", "user.email", name});
            Exec.system((String[])new String[]{"git", "config", "--local", "user.email", email});
            Exec.system((String[])new String[]{"git", "config", "--local", "commit.gpgsign", "false"});
            Exec.system((String[])new String[]{"git", "add", "."});
            Exec.system((String[])new String[]{"git", "commit", "-m", "Initial commit"});
        });
    }
}

