package grim.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * Annotation indicating that the class may generate a clinit when compiled to javascript.
 * The same rules could be generated by the slightly more verbose {@link KeepPattern} annotation but this
 * annotation exists as it represents a common use case.
 */
@Documented
@Target( ElementType.TYPE )
public @interface KeepClinit
{
}
