/*
 * Decompiled with CFR 0.152.
 */
package grim.processor;

import grim.processor.ConditionDescriptor;
import grim.processor.vendor.google.auto.common.SuperficialValidation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"grim.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class GrimProcessor
extends AbstractProcessor {
    @Nonnull
    private static final String BASE_RESOURCE_PATH = "META-INF/grim/";
    @Nonnull
    private static final String SUFFIX = ".grim.json";
    @Nonnull
    private static final String SENTINEL = "<default>";
    @Nonnull
    private HashSet<TypeElement> _deferred = new HashSet();

    @Override
    public boolean process(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        ArrayList<PackageElement> packagesToProcess = new ArrayList<PackageElement>();
        HashMap<String, TypeElement> typesToProcess = new HashMap<String, TypeElement>();
        for (TypeElement typeElement : annotations) {
            TypeElement typeElement2;
            Set<? extends Element> elements;
            String annotationName = typeElement.getQualifiedName().toString();
            if ("grim.annotations.OmitPattern".equals(annotationName) || "grim.annotations.OmitPatterns".equals(annotationName) || "grim.annotations.KeepPattern".equals(annotationName) || "grim.annotations.KeepPatterns".equals(annotationName)) {
                elements = env.getElementsAnnotatedWith(typeElement);
                for (Element element : elements) {
                    packagesToProcess.add((PackageElement)element);
                }
                continue;
            }
            if ("grim.annotations.OmitClinit".equals(annotationName) || "grim.annotations.OmitType".equals(annotationName) || "grim.annotations.OmitTypes".equals(annotationName) || "grim.annotations.KeepClinit".equals(annotationName) || "grim.annotations.KeepType".equals(annotationName) || "grim.annotations.KeepTypes".equals(annotationName)) {
                elements = env.getElementsAnnotatedWith(typeElement);
                for (Element element : elements) {
                    typeElement2 = (TypeElement)element;
                    typesToProcess.put(typeElement2.getQualifiedName().toString(), typeElement2);
                }
                continue;
            }
            if (!"grim.annotations.OmitSymbols".equals(annotationName) && !"grim.annotations.OmitSymbol".equals(annotationName) && !"grim.annotations.KeepSymbols".equals(annotationName) && !"grim.annotations.KeepSymbol".equals(annotationName)) continue;
            elements = env.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                typeElement2 = (TypeElement)element.getEnclosingElement();
                typesToProcess.put(typeElement2.getQualifiedName().toString(), typeElement2);
            }
        }
        this.processPackages(packagesToProcess);
        this.processTypeElements(this.getElementsToProcess(typesToProcess.values()));
        if (env.getRootElements().isEmpty() && !this._deferred.isEmpty()) {
            this._deferred.forEach(this::processingErrorMessage);
            this._deferred.clear();
        }
        return true;
    }

    private void processPackages(@Nonnull Collection<PackageElement> elements) {
        for (PackageElement element : elements) {
            this.processAction(element, () -> this.process(element));
        }
    }

    private void process(@Nonnull PackageElement element) throws IOException {
        this.writeJsonResource(element, this.toGrimJsonFilename(element), g -> this.processPatterns(element, (JsonGenerator)g));
    }

    private void processTypeElements(@Nonnull Collection<TypeElement> elements) {
        for (TypeElement element : elements) {
            this.processAction(element, () -> this.process(element));
        }
    }

    private void processAction(@Nonnull Element element, @Nonnull Action action) {
        try {
            action.call();
        }
        catch (IOException ioe) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ioe.getMessage(), element);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sw.flush();
            String message = "Unexpected error will running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. Please report the failure to the developers so that it can be fixed.\n Report the error at: https://github.com/realityforge/grim/issues\n\n\n" + sw.toString();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
        }
    }

    private void process(@Nonnull TypeElement element) throws IOException {
        this.writeJsonResource(element, this.toGrimJsonFilename(element), g -> {
            this.processClinits(element, (JsonGenerator)g);
            this.processTypes(element, (JsonGenerator)g);
            this.processSymbols(element, (JsonGenerator)g);
        });
    }

    private void writeJsonResource(@Nonnull Element element, @Nonnull String filename, @Nonnull Consumer<JsonGenerator> action) throws IOException {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(properties);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator g = generatorFactory.createGenerator((OutputStream)baos);
        g.writeStartArray();
        action.accept(g);
        g.writeEnd();
        g.close();
        this.writeResource(filename, this.formatJson(baos.toString()), element);
    }

    private void writeResource(@Nonnull String filename, @Nonnull String content, @Nonnull Element element) throws IOException {
        FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", filename, element);
        try (OutputStream outputStream = resource.openOutputStream();){
            outputStream.write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            resource.delete();
            throw e;
        }
    }

    private void processClinits(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        this.processClinit(element, "grim.annotations.OmitClinit", g);
        this.processClinit(element, "grim.annotations.KeepClinit", g);
    }

    private void processClinit(@Nonnull TypeElement element, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        AnnotationMirror annotation = this.findAnnotationByType(element, annotationName);
        if (null != annotation) {
            g.writeStartObject();
            if ("grim.annotations.KeepClinit".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(element));
            g.write("member", this.quotedName("$clinit"));
            g.writeEnd();
        }
    }

    private void processTypes(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        this.processTypeAnnotations(element, "grim.annotations.OmitTypes", "grim.annotations.OmitType", g);
        this.processTypeAnnotations(element, "grim.annotations.KeepTypes", "grim.annotations.KeepType", g);
    }

    private void processTypeAnnotations(@Nonnull TypeElement element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        for (AnnotationMirror annotation : this.getRepeatingAnnotations(element, containerAnnotation, annotationName)) {
            g.writeStartObject();
            if ("grim.annotations.KeepType".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(element));
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    private void processPatterns(@Nonnull PackageElement element, @Nonnull JsonGenerator g) {
        this.processPatternAnnotations(element, "grim.annotations.OmitPatterns", "grim.annotations.OmitPattern", g);
        this.processPatternAnnotations(element, "grim.annotations.KeepPatterns", "grim.annotations.KeepPattern", g);
    }

    private void processPatternAnnotations(@Nonnull PackageElement element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        for (AnnotationMirror annotation : this.getRepeatingAnnotations(element, containerAnnotation, annotationName)) {
            String typePattern;
            g.writeStartObject();
            if ("grim.annotations.KeepPattern".equals(annotationName)) {
                g.write("keep", true);
            }
            String actualTypePattern = SENTINEL.equals(typePattern = (String)this.getAnnotationValue(annotation, "type").getValue()) ? "^" + element.getQualifiedName().toString().replace(".", "\\.") + "\\..*$" : typePattern;
            g.write("type", actualTypePattern);
            String symbolPattern = (String)this.getAnnotationValue(annotation, "symbol").getValue();
            if (!SENTINEL.equals(symbolPattern)) {
                g.write("member", symbolPattern);
            }
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    private void processSymbols(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!(element2 instanceof ExecutableElement) && !(element2 instanceof VariableElement)) continue;
            this.processSymbol(element, element2, g);
        }
    }

    private void processSymbol(@Nonnull TypeElement typeElement, @Nonnull Element element, @Nonnull JsonGenerator g) {
        this.processSymbolAnnotations(typeElement, element, "grim.annotations.OmitSymbols", "grim.annotations.OmitSymbol", g);
        this.processSymbolAnnotations(typeElement, element, "grim.annotations.KeepSymbols", "grim.annotations.KeepSymbol", g);
    }

    private void processSymbolAnnotations(@Nonnull TypeElement typeElement, @Nonnull Element element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        for (AnnotationMirror annotation : this.getRepeatingAnnotations(element, containerAnnotation, annotationName)) {
            g.writeStartObject();
            if ("grim.annotations.KeepSymbol".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(typeElement));
            g.write("member", this.getMemberName(element));
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    @Nonnull
    private String getMemberName(@Nonnull Element element) {
        if (ElementKind.CONSTRUCTOR == element.getKind()) {
            return this.quotedName(element.getEnclosingElement().getSimpleName().toString());
        }
        if (ElementKind.METHOD == element.getKind()) {
            return this.quotedMethodName(element.getSimpleName().toString());
        }
        assert (ElementKind.FIELD == element.getKind());
        return this.quotedName(element.getSimpleName().toString());
    }

    private void processConditions(@Nonnull Element element, @Nonnull AnnotationMirror annotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        String when = (String)this.getAnnotationValue(annotation, "when").getValue();
        String unless = (String)this.getAnnotationValue(annotation, "unless").getValue();
        if (!"".equals(when) && !"".equals(unless)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotationName + " annotation incorrectly specifies both a when and unless parameter", element, annotation);
        }
        if (!"".equals(when)) {
            this.parseCondition(when, ConditionDescriptor.Operator.EQUALS).generate(g);
        } else if (!"".equals(unless)) {
            this.parseCondition(unless, ConditionDescriptor.Operator.NOT_EQUALS).generate(g);
        }
    }

    @Nonnull
    private ConditionDescriptor parseCondition(@Nonnull String expression, @Nonnull ConditionDescriptor.Operator operator) {
        int split = expression.indexOf("=");
        if (-1 == split) {
            return new ConditionDescriptor(expression, "true", operator);
        }
        return new ConditionDescriptor(expression.substring(0, split), expression.substring(split + 1), operator);
    }

    @Nonnull
    private String toGrimJsonFilename(@Nonnull PackageElement element) {
        return BASE_RESOURCE_PATH + this.packageFilename(element) + "package-info" + SUFFIX;
    }

    @Nonnull
    private String toGrimJsonFilename(@Nonnull TypeElement element) {
        return BASE_RESOURCE_PATH + this.typeName(element) + SUFFIX;
    }

    @Nonnull
    private String typeName(@Nonnull Element element) {
        Element enclosingElement = element.getEnclosingElement();
        String parent = enclosingElement instanceof PackageElement ? this.packageFilename((PackageElement)enclosingElement) : this.typeName(enclosingElement) + "$";
        return parent + element.getSimpleName().toString();
    }

    @Nonnull
    private String packageFilename(@Nonnull PackageElement packageElement) {
        return packageElement.getQualifiedName().toString().replace(".", "/") + "/";
    }

    @Nonnull
    private String toTypePattern(@Nonnull TypeElement element) {
        return this.quotedName(element.getQualifiedName().toString());
    }

    @Nonnull
    private String quotedName(@Nonnull String string) {
        return "^" + Pattern.quote(string) + "$";
    }

    @Nonnull
    private String quotedMethodName(@Nonnull String string) {
        return "^\\$?" + Pattern.quote(string) + "$";
    }

    private void processingErrorMessage(@Nonnull TypeElement target) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "GrimProcessor unable to process " + target.getQualifiedName() + " because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", target);
    }

    @Nonnull
    private Collection<TypeElement> getElementsToProcess(@Nonnull Collection<TypeElement> elements) {
        List<TypeElement> deferred = this._deferred.stream().map(e -> this.processingEnv.getElementUtils().getTypeElement(e.getQualifiedName())).collect(Collectors.toList());
        this._deferred = new HashSet();
        ArrayList<TypeElement> elementsToProcess = new ArrayList<TypeElement>();
        this.collectElementsToProcess(elements, elementsToProcess);
        this.collectElementsToProcess(deferred, elementsToProcess);
        return elementsToProcess;
    }

    private void collectElementsToProcess(@Nonnull Collection<TypeElement> elements, @Nonnull List<TypeElement> elementsToProcess) {
        for (TypeElement element : elements) {
            if (SuperficialValidation.validateElement(element)) {
                elementsToProcess.add(element);
                continue;
            }
            this._deferred.add(element);
        }
    }

    @Nonnull
    private String formatJson(@Nonnull String input) {
        return input.replaceAll("(?m)^ {4}\\{", "  {").replaceAll("(?m)^ {4}}", "  }").replaceAll("(?m)^ {8}\"", "    \"").replaceAll("(?m)^ {8}]", "    ]").replaceAll("(?m)^ {12}\\{", "      {").replaceAll("(?m)^ {12}}", "      }").replaceAll("(?m)^ {16}\"", "        \"").replaceAll("(?m)^\n\\[\n", "[\n") + "\n";
    }

    @Nonnull
    private List<AnnotationMirror> getRepeatingAnnotations(@Nonnull Element typeElement, @Nonnull String containerClassName, @Nonnull String annotationClassName) {
        AnnotationValue annotationValue = this.findAnnotationValue(typeElement, containerClassName, "value");
        if (null != annotationValue) {
            return ((List)annotationValue.getValue()).stream().map(v -> (AnnotationMirror)v.getValue()).collect(Collectors.toList());
        }
        AnnotationMirror annotation = this.findAnnotationByType(typeElement, annotationClassName);
        if (null != annotation) {
            return Collections.singletonList(annotation);
        }
        return Collections.emptyList();
    }

    @Nullable
    private AnnotationValue findAnnotationValue(@Nonnull Element typeElement, @Nonnull String annotationClassName, @Nonnull String parameterName) {
        AnnotationMirror mirror = this.findAnnotationByType(typeElement, annotationClassName);
        if (null != mirror) {
            return this.findAnnotationValue(mirror, parameterName);
        }
        return null;
    }

    @Nullable
    private AnnotationValue findAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotation);
        ExecutableElement annotationKey = values.keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        return values.get(annotationKey);
    }

    @Nonnull
    private AnnotationValue getAnnotationValue(@Nonnull AnnotationMirror annotation, @Nonnull String parameterName) {
        AnnotationValue value = this.findAnnotationValue(annotation, parameterName);
        assert (null != value);
        return value;
    }

    @Nullable
    private AnnotationMirror findAnnotationByType(@Nonnull Element typeElement, @Nonnull String annotationClassName) {
        return typeElement.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationClassName)).findFirst().orElse(null);
    }

    @FunctionalInterface
    private static interface Action {
        public void call() throws Exception;
    }
}

