/*
 * Decompiled with CFR 0.152.
 */
package grim.processor;

import grim.processor.ConditionDescriptor;
import grim.processor.vendor.proton.AbstractStandardProcessor;
import grim.processor.vendor.proton.AnnotationsUtil;
import grim.processor.vendor.proton.JsonUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.json.stream.JsonGenerator;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"grim.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"grim.defer.unresolved", "grim.defer.errors"})
public final class GrimProcessor
extends AbstractStandardProcessor {
    @Nonnull
    static final String BASE_RESOURCE_PATH = "META-INF/grim";
    @Nonnull
    static final String SUFFIX = ".grim.json";
    @Nonnull
    private static final String SENTINEL = "<default>";

    @Override
    @Nonnull
    protected String getIssueTrackerURL() {
        return "https://github.com/realityforge/grim/issues";
    }

    @Override
    @Nonnull
    protected String getOptionPrefix() {
        return "grim";
    }

    @Override
    public boolean process(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env) {
        HashSet<PackageElement> packagesToProcess = new HashSet<PackageElement>();
        HashMap<String, TypeElement> typesToProcess = new HashMap<String, TypeElement>();
        for (TypeElement typeElement : annotations) {
            TypeElement typeElement2;
            Set<? extends Element> elements;
            String annotationName = typeElement.getQualifiedName().toString();
            if ("grim.annotations.OmitPattern".equals(annotationName) || "grim.annotations.OmitPatterns".equals(annotationName) || "grim.annotations.KeepPattern".equals(annotationName) || "grim.annotations.KeepPatterns".equals(annotationName)) {
                elements = env.getElementsAnnotatedWith(typeElement);
                for (Element element : elements) {
                    packagesToProcess.add((PackageElement)element);
                }
                continue;
            }
            if ("grim.annotations.OmitClinit".equals(annotationName) || "grim.annotations.OmitType".equals(annotationName) || "grim.annotations.OmitTypes".equals(annotationName) || "grim.annotations.KeepClinit".equals(annotationName) || "grim.annotations.KeepType".equals(annotationName) || "grim.annotations.KeepTypes".equals(annotationName)) {
                elements = env.getElementsAnnotatedWith(typeElement);
                for (Element element : elements) {
                    typeElement2 = (TypeElement)element;
                    typesToProcess.put(typeElement2.getQualifiedName().toString(), typeElement2);
                }
                continue;
            }
            if (!"grim.annotations.OmitSymbols".equals(annotationName) && !"grim.annotations.OmitSymbol".equals(annotationName) && !"grim.annotations.KeepSymbols".equals(annotationName) && !"grim.annotations.KeepSymbol".equals(annotationName)) continue;
            elements = env.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                typeElement2 = (TypeElement)element.getEnclosingElement();
                typesToProcess.put(typeElement2.getQualifiedName().toString(), typeElement2);
            }
        }
        this.processPackages(env, packagesToProcess);
        this.processTypes(env, typesToProcess.values());
        this.errorIfProcessingOverAndInvalidTypesDetected(env);
        return true;
    }

    private void processTypes(@Nonnull RoundEnvironment env, @Nonnull Collection<TypeElement> elements) {
        for (TypeElement element : elements) {
            this.performAction(env, this::processTypeElement, element);
        }
    }

    private void processPackages(@Nonnull RoundEnvironment env, @Nonnull Collection<PackageElement> elements) {
        for (PackageElement element : elements) {
            this.performAction(env, this::processPackageElement, element);
        }
    }

    private void processPackageElement(@Nonnull PackageElement element) throws IOException {
        JsonUtil.writeJsonResource(this.processingEnv, element, this.toJsonFilename(element), g -> this.emitPatterns(element, (JsonGenerator)g));
    }

    private void processTypeElement(@Nonnull TypeElement element) throws IOException {
        JsonUtil.writeJsonResource(this.processingEnv, element, this.toJsonFilename(element), g -> this.emitPatterns(element, (JsonGenerator)g));
    }

    private void emitPatterns(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        g.writeStartArray();
        this.processClinits(element, g);
        this.processTypes(element, g);
        this.processSymbols(element, g);
        g.writeEnd();
    }

    private void processClinits(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        this.processClinit(element, "grim.annotations.OmitClinit", g);
        this.processClinit(element, "grim.annotations.KeepClinit", g);
    }

    private void processClinit(@Nonnull TypeElement element, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(element, annotationName);
        if (null != annotation) {
            g.writeStartObject();
            if ("grim.annotations.KeepClinit".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(element));
            g.write("member", this.quotedName("$clinit"));
            g.writeEnd();
        }
    }

    private void processTypes(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        this.processTypeAnnotations(element, "grim.annotations.OmitTypes", "grim.annotations.OmitType", g);
        this.processTypeAnnotations(element, "grim.annotations.KeepTypes", "grim.annotations.KeepType", g);
    }

    private void processTypeAnnotations(@Nonnull TypeElement element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        for (AnnotationMirror annotation : AnnotationsUtil.getRepeatingAnnotations(element, containerAnnotation, annotationName)) {
            g.writeStartObject();
            if ("grim.annotations.KeepType".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(element));
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    private void emitPatterns(@Nonnull PackageElement element, @Nonnull JsonGenerator g) {
        g.writeStartArray();
        this.processPatternAnnotations(element, "grim.annotations.OmitPatterns", "grim.annotations.OmitPattern", g);
        this.processPatternAnnotations(element, "grim.annotations.KeepPatterns", "grim.annotations.KeepPattern", g);
        g.writeEnd();
    }

    private void processPatternAnnotations(@Nonnull PackageElement element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        List<AnnotationMirror> annotations = AnnotationsUtil.getRepeatingAnnotations(element, containerAnnotation, annotationName);
        for (AnnotationMirror annotation : annotations) {
            String typePattern;
            g.writeStartObject();
            if ("grim.annotations.KeepPattern".equals(annotationName)) {
                g.write("keep", true);
            }
            String actualTypePattern = SENTINEL.equals(typePattern = (String)AnnotationsUtil.getAnnotationValueValue(annotation, "type")) ? "^" + element.getQualifiedName().toString().replace(".", "\\.") + "\\..*$" : typePattern;
            g.write("type", actualTypePattern);
            String symbolPattern = (String)AnnotationsUtil.getAnnotationValueValue(annotation, "symbol");
            if (!SENTINEL.equals(symbolPattern)) {
                g.write("member", symbolPattern);
            }
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    private void processSymbols(@Nonnull TypeElement element, @Nonnull JsonGenerator g) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!(element2 instanceof ExecutableElement) && !(element2 instanceof VariableElement)) continue;
            this.processSymbol(element, element2, g);
        }
    }

    private void processSymbol(@Nonnull TypeElement typeElement, @Nonnull Element element, @Nonnull JsonGenerator g) {
        this.processSymbolAnnotations(typeElement, element, "grim.annotations.OmitSymbols", "grim.annotations.OmitSymbol", g);
        this.processSymbolAnnotations(typeElement, element, "grim.annotations.KeepSymbols", "grim.annotations.KeepSymbol", g);
    }

    private void processSymbolAnnotations(@Nonnull TypeElement typeElement, @Nonnull Element element, @Nonnull String containerAnnotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        List<AnnotationMirror> annotations = AnnotationsUtil.getRepeatingAnnotations(element, containerAnnotation, annotationName);
        for (AnnotationMirror annotation : annotations) {
            g.writeStartObject();
            if ("grim.annotations.KeepSymbol".equals(annotationName)) {
                g.write("keep", true);
            }
            g.write("type", this.toTypePattern(typeElement));
            g.write("member", this.getMemberName(element));
            this.processConditions(element, annotation, annotationName, g);
            g.writeEnd();
        }
    }

    @Nonnull
    private String getMemberName(@Nonnull Element element) {
        if (ElementKind.CONSTRUCTOR == element.getKind()) {
            return this.quotedName(element.getEnclosingElement().getSimpleName().toString());
        }
        if (ElementKind.METHOD == element.getKind()) {
            return this.quotedMethodName(element.getSimpleName().toString());
        }
        assert (ElementKind.FIELD == element.getKind());
        return this.quotedName(element.getSimpleName().toString());
    }

    private void processConditions(@Nonnull Element element, @Nonnull AnnotationMirror annotation, @Nonnull String annotationName, @Nonnull JsonGenerator g) {
        String when = (String)AnnotationsUtil.getAnnotationValueValue(annotation, "when");
        String unless = (String)AnnotationsUtil.getAnnotationValueValue(annotation, "unless");
        if (!"".equals(when) && !"".equals(unless)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotationName + " annotation incorrectly specifies both a when and unless parameter", element, annotation);
        }
        if (!"".equals(when)) {
            this.parseCondition(when, ConditionDescriptor.Operator.EQUALS).generate(g);
        } else if (!"".equals(unless)) {
            this.parseCondition(unless, ConditionDescriptor.Operator.NOT_EQUALS).generate(g);
        }
    }

    @Nonnull
    private ConditionDescriptor parseCondition(@Nonnull String expression, @Nonnull ConditionDescriptor.Operator operator) {
        int split = expression.indexOf("=");
        if (-1 == split) {
            return new ConditionDescriptor(expression, "true", operator);
        }
        return new ConditionDescriptor(expression.substring(0, split), expression.substring(split + 1), operator);
    }

    @Nonnull
    private String toJsonFilename(@Nonnull PackageElement element) {
        return "META-INF/grim/" + this.packageFilename(element) + "package-info" + SUFFIX;
    }

    @Nonnull
    private String toJsonFilename(@Nonnull TypeElement element) {
        return "META-INF/grim/" + this.typeName(element) + SUFFIX;
    }

    @Nonnull
    private String typeName(@Nonnull Element element) {
        Element enclosingElement = element.getEnclosingElement();
        String parent = enclosingElement instanceof PackageElement ? this.packageFilename((PackageElement)enclosingElement) : this.typeName(enclosingElement) + "$";
        return parent + element.getSimpleName().toString();
    }

    @Nonnull
    private String packageFilename(@Nonnull PackageElement packageElement) {
        return packageElement.getQualifiedName().toString().replace(".", "/") + "/";
    }

    @Nonnull
    private String toTypePattern(@Nonnull TypeElement element) {
        return this.quotedName(element.getQualifiedName().toString());
    }

    @Nonnull
    private String quotedName(@Nonnull String string) {
        return "^" + Pattern.quote(string) + "$";
    }

    @Nonnull
    private String quotedMethodName(@Nonnull String string) {
        return "^\\$?" + Pattern.quote(string) + "$";
    }
}

