/*
 * Decompiled with CFR 0.152.
 */
package grim.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;

final class ConditionDescriptor {
    @Nonnull
    private final String _property;
    @Nonnull
    private final String _value;
    @Nonnull
    private final Operator _operator;

    ConditionDescriptor(@Nonnull String property, @Nonnull String value, @Nonnull Operator operator) {
        this._property = Objects.requireNonNull(property);
        this._value = Objects.requireNonNull(value);
        this._operator = Objects.requireNonNull(operator);
    }

    void generate(@Nonnull JsonGenerator g) {
        g.write("property", this._property);
        g.write("operator", this._operator == Operator.EQUALS ? "EQ" : "NEQ");
        g.write("value", this._value);
    }

    static enum Operator {
        EQUALS,
        NOT_EQUALS;

    }
}

