/*
 * Decompiled with CFR 0.152.
 */
package grim.processor.vendor.proton;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import grim.processor.vendor.proton.TypesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;

public final class SuppressWarningsUtil {
    private SuppressWarningsUtil() {
    }

    @Nonnull
    public static AnnotationSpec suppressWarningsAnnotation(String ... warnings) {
        return Objects.requireNonNull(SuppressWarningsUtil.maybeSuppressWarningsAnnotation(warnings));
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(String ... warnings) {
        List<String> actualWarnings = Arrays.stream(warnings).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (actualWarnings.isEmpty()) {
            return null;
        }
        AnnotationSpec.Builder builder = AnnotationSpec.builder(SuppressWarnings.class);
        actualWarnings.forEach(w -> builder.addMember("value", "$S", new Object[]{w}));
        return builder.build();
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder method, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            method.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull MethodSpec.Builder method, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            method.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull FieldSpec.Builder field, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            field.addAnnotation(suppress);
        }
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull TypeMirror type) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.singleton(type));
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull Collection<TypeMirror> types) {
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, field, Collections.emptyList(), types);
    }

    public static void addSuppressWarningsIfRequired(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ParameterSpec.Builder field, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        AnnotationSpec suppress = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, additionalSuppressions, types);
        if (null != suppress) {
            field.addAnnotation(suppress);
        }
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Collection<TypeMirror> types) {
        return SuppressWarningsUtil.maybeSuppressWarningsAnnotation(processingEnv, Collections.emptyList(), types);
    }

    @Nullable
    public static AnnotationSpec maybeSuppressWarningsAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Collection<String> additionalSuppressions, @Nonnull Collection<TypeMirror> types) {
        boolean hasDeprecatedTypes;
        boolean hasRawTypes = additionalSuppressions.contains("rawtypes") || types.stream().anyMatch(t -> TypesUtil.hasRawTypes(processingEnv, t));
        boolean bl = hasDeprecatedTypes = additionalSuppressions.contains("deprecation") || types.stream().anyMatch(t -> TypesUtil.isDeprecated(processingEnv, t));
        if (hasRawTypes || hasDeprecatedTypes || !additionalSuppressions.isEmpty()) {
            ArrayList<String> suppressions = new ArrayList<String>(additionalSuppressions);
            if (hasRawTypes) {
                suppressions.add("rawtypes");
            }
            if (hasDeprecatedTypes) {
                suppressions.add("deprecation");
            }
            return SuppressWarningsUtil.suppressWarningsAnnotation((String[])suppressions.stream().sorted().distinct().toArray(String[]::new));
        }
        return null;
    }
}

