/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class Scalars {
    public static GraphQLScalarType DATE_TIME = new GraphQLScalarType("DateTime", "DataTime scalar", (Coercing)new DateTimeCoercing());

    private static class DateTimeCoercing
    implements Coercing<Date, String> {
        private DateTimeCoercing() {
        }

        public String serialize(Object input) {
            Date date = (Date)input;
            return date.toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public Date parseValue(Object input) {
            return this.parseLiteral(input);
        }

        public Date parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return Date.from(ZonedDateTime.parse(((StringValue)input).getValue()).toInstant());
            }
            if (input instanceof IntValue) {
                long epochMilli = ((IntValue)input).getValue().longValue();
                return Date.from(Instant.ofEpochMilli(epochMilli));
            }
            return null;
        }
    }
}

