/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleTypeResolver
implements TypeResolver {
    private final LinkedHashMap<Class, GraphQLObjectType> _typeMap;

    public SimpleTypeResolver(@Nonnull LinkedHashMap<Class, GraphQLObjectType> typeMap) {
        this._typeMap = Objects.requireNonNull(typeMap);
    }

    public GraphQLObjectType getType(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        for (Map.Entry<Class, GraphQLObjectType> entry : this._typeMap.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("Unable to locate object type for " + object);
    }

    public static class Builder {
        private final LinkedHashMap<Class, GraphQLObjectType> _typeMap = new LinkedHashMap();

        @Nonnull
        public Builder add(@Nonnull Class type, @Nonnull GraphQLObjectType objectType) {
            this._typeMap.put(type, objectType);
            return this;
        }

        @Nonnull
        public TypeResolver build() {
            return new SimpleTypeResolver(this._typeMap);
        }
    }
}

