/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.NoOpInstrumentation;
import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLServlet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.realityforge.graphql.domgen.DataFetchingError;
import org.realityforge.graphql.domgen.ValidationError;
import org.realityforge.graphql.domgen.WrapperRuntimeException;

public abstract class AbstractDomgenGraphQLEndpoint
extends GraphQLServlet {
    private final DefaultExecutionStrategyProvider _executionStrategyProvider = new DefaultExecutionStrategyProvider();

    protected GraphQLContext createContext(Optional<HttpServletRequest> request, Optional<HttpServletResponse> response) {
        return new GraphQLContext(request, response);
    }

    protected ExecutionStrategyProvider getExecutionStrategyProvider() {
        return this._executionStrategyProvider;
    }

    protected Instrumentation getInstrumentation() {
        return NoOpInstrumentation.INSTANCE;
    }

    protected Map<String, Object> transformVariables(GraphQLSchema schema, String query, Map<String, Object> variables) {
        return variables;
    }

    @Nonnull
    protected List<GraphQLError> filterGraphQLErrors(@Nonnull List<GraphQLError> errors) {
        return errors.stream().filter(e -> e instanceof ExceptionWhileDataFetching || e instanceof NonNullableFieldWasNullException || this.isClientError((GraphQLError)e)).map(e -> e instanceof ExceptionWhileDataFetching ? this.wrapDataFetcherError((ExceptionWhileDataFetching)e) : e).map(e -> e instanceof NonNullableFieldWasNullException ? new DataFetchingError(e.getMessage()) : e).collect(Collectors.toList());
    }

    @Nonnull
    protected GraphQLError wrapDataFetcherError(@Nonnull ExceptionWhileDataFetching e) {
        Throwable t = this.unwrap(e.getException());
        return this.throwableToError(t);
    }

    @Nonnull
    private GraphQLError throwableToError(@Nonnull Throwable t) {
        if (t instanceof NoResultException) {
            return new ValidationError("Failed to load expected entity in database");
        }
        return new DataFetchingError(this.getMessage(t));
    }

    @Nonnull
    protected String getMessage(@Nonnull Throwable t) {
        return "Exception while fetching data: " + t;
    }

    @Nonnull
    protected Throwable unwrap(@Nonnull Throwable root) {
        Throwable t = root;
        while (this.isWrapperException(t) && null != t.getCause()) {
            t = t.getCause();
        }
        return t;
    }

    protected boolean isWrapperException(@Nonnull Throwable t) {
        return t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException || t instanceof WrapperRuntimeException;
    }
}

