/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLSchemaProvider;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.enterprise.concurrent.ContextService;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import org.realityforge.graphql.domgen.ExceptingDataFetcher;
import org.realityforge.graphql.domgen.TransactionEnabledDataFetcher;

public abstract class AbstractGraphQLSchemaProvider
implements GraphQLSchemaProvider {
    private final HashMap<String, GraphQLScalarType> _scalarTypes = new HashMap();
    private final HashMap<String, GraphQLEnumType> _enumTypes = new HashMap();
    private final HashMap<String, GraphQLInterfaceType> _interfaceTypes = new HashMap();
    private final HashMap<String, GraphQLInputType> _inputTypes = new HashMap();
    private final HashMap<String, GraphQLObjectType> _objectTypes = new HashMap();
    private GraphQLSchema _schema;

    protected void postConstruct() {
        this._schema = this.buildGraphQLSchema();
    }

    public GraphQLSchema getSchema(HttpServletRequest request) {
        return this._schema;
    }

    public GraphQLSchema getSchema() {
        return this._schema;
    }

    public GraphQLSchema getReadOnlySchema(HttpServletRequest request) {
        return this._schema;
    }

    @Nonnull
    private GraphQLSchema buildGraphQLSchema() {
        this.populateGraphQLSchema();
        GraphQLObjectType query = this._objectTypes.get("Query");
        if (null == query) {
            throw new IllegalStateException("Unable to build schema as no Query object type has been defined");
        }
        GraphQLObjectType mutation = this._objectTypes.get("Mutation");
        GraphQLObjectType subscription = this._objectTypes.get("Subscription");
        HashSet<Object> dictionary = new HashSet<Object>();
        dictionary.addAll(this._scalarTypes.values());
        dictionary.addAll(this._enumTypes.values());
        dictionary.addAll(this._interfaceTypes.values());
        dictionary.addAll(this._objectTypes.values());
        return new GraphQLSchema.Builder().query(query).mutation(mutation).subscription(subscription).build(dictionary);
    }

    protected abstract void populateGraphQLSchema();

    protected void registerStandardScalarTypes() {
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLString);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLBigDecimal);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLBigInteger);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLBoolean);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLByte);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLChar);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLFloat);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLID);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLInt);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLLong);
        this.registerScalarTypeUnlessRegistered(Scalars.GraphQLShort);
    }

    protected void addFieldUnlessNull(@Nonnull GraphQLInputObjectType.Builder objectType, @Nullable GraphQLInputObjectField field) {
        if (null != field) {
            objectType.field(field);
        }
    }

    protected void addFieldUnlessNull(@Nonnull GraphQLInterfaceType.Builder objectType, @Nullable GraphQLFieldDefinition field) {
        if (null != field) {
            objectType.field(field);
        }
    }

    protected void addFieldUnlessNull(@Nonnull GraphQLObjectType.Builder objectType, @Nullable GraphQLFieldDefinition field) {
        if (null != field) {
            objectType.field(field);
        }
    }

    protected boolean isScalarTypeRegistered(@Nonnull GraphQLScalarType scalarType) {
        return this._scalarTypes.containsKey(scalarType.getName());
    }

    private void registerScalarTypeUnlessRegistered(@Nonnull GraphQLScalarType scalarType) {
        if (!this.isScalarTypeRegistered(scalarType)) {
            this.registerScalarType(scalarType);
        }
    }

    protected void registerScalarTypeUnlessNull(@Nullable GraphQLScalarType scalarType) {
        if (null != scalarType) {
            this.registerScalarType(scalarType);
        }
    }

    protected void registerScalarType(@Nonnull GraphQLScalarType scalarType) {
        String name = scalarType.getName();
        if (this._scalarTypes.containsKey(name)) {
            String message = String.format("Attempting to register scalarType '%s' that duplicates existing scalarType", name);
            throw new IllegalStateException(message);
        }
        this._scalarTypes.put(name, scalarType);
    }

    @Nonnull
    protected GraphQLScalarType scalarType(@Nonnull String key) {
        GraphQLScalarType scalarType = this._scalarTypes.get(key);
        if (null == scalarType) {
            String message = String.format("Unable to locate scalarType '%s'. Please ensure it is defined prior to invoking scalarType() method", key);
            throw new IllegalStateException(message);
        }
        return scalarType;
    }

    protected boolean isEnumTypeRegistered(@Nonnull GraphQLEnumType enumType) {
        return this._enumTypes.containsKey(enumType.getName());
    }

    protected void registerEnumTypeUnlessNull(@Nullable GraphQLEnumType enumType) {
        if (null != enumType) {
            this.registerEnumType(enumType);
        }
    }

    protected void registerEnumType(@Nonnull GraphQLEnumType enumType) {
        String name = enumType.getName();
        if (this._enumTypes.containsKey(name)) {
            String message = String.format("Attempting to register enumType '%s' that duplicates existing enumType", name);
            throw new IllegalStateException(message);
        }
        this._enumTypes.put(name, enumType);
    }

    @Nonnull
    protected GraphQLEnumType enumType(@Nonnull String key) {
        GraphQLEnumType enumType = this._enumTypes.get(key);
        if (null == enumType) {
            String message = String.format("Unable to locate enumType '%s'. Please ensure it is defined prior to invoking enumType() method", key);
            throw new IllegalStateException(message);
        }
        return enumType;
    }

    protected boolean isInterfaceTypeRegistered(@Nonnull GraphQLInterfaceType interfaceType) {
        return this._interfaceTypes.containsKey(interfaceType.getName());
    }

    protected void registerInterfaceTypeUnlessNull(@Nullable GraphQLInterfaceType interfaceType) {
        if (null != interfaceType) {
            this.registerInterfaceType(interfaceType);
        }
    }

    protected void registerInterfaceType(@Nonnull GraphQLInterfaceType interfaceType) {
        String name = interfaceType.getName();
        if (this._interfaceTypes.containsKey(name)) {
            String message = String.format("Attempting to register interfaceType '%s' that duplicates existing interfaceType", name);
            throw new IllegalStateException(message);
        }
        this._interfaceTypes.put(name, interfaceType);
    }

    @Nonnull
    protected GraphQLInterfaceType interfaceType(@Nonnull String key) {
        GraphQLInterfaceType interfaceType = this._interfaceTypes.get(key);
        if (null == interfaceType) {
            String message = String.format("Unable to locate interfaceType '%s'. Please ensure it is defined prior to invoking interfaceType() method", key);
            throw new IllegalStateException(message);
        }
        return interfaceType;
    }

    protected void registerInputTypeUnlessNull(@Nullable GraphQLInputType inputType) {
        if (null != inputType) {
            this.registerInputType(inputType);
        }
    }

    protected void registerInputType(@Nonnull GraphQLInputType inputType) {
        String name = inputType.getName();
        if (this._inputTypes.containsKey(name)) {
            String message = String.format("Attempting to register inputType '%s' that duplicates existing inputType", name);
            throw new IllegalStateException(message);
        }
        this._inputTypes.put(name, inputType);
    }

    @Nonnull
    protected GraphQLInputType inputType(@Nonnull String key) {
        GraphQLInputType inputType = this._inputTypes.get(key);
        if (null == inputType) {
            String message = String.format("Unable to locate inputType '%s'. Please ensure it is defined prior to invoking inputType() method", key);
            throw new IllegalStateException(message);
        }
        return inputType;
    }

    protected void registerObjectTypeUnlessNull(@Nullable GraphQLObjectType objectType) {
        if (null != objectType) {
            this.registerObjectType(objectType);
        }
    }

    protected void registerObjectType(@Nonnull GraphQLObjectType objectType) {
        String name = objectType.getName();
        if (this._objectTypes.containsKey(name)) {
            String message = String.format("Attempting to register objectType '%s' that duplicates existing objectType", name);
            throw new IllegalStateException(message);
        }
        this._objectTypes.put(name, objectType);
    }

    @Nonnull
    protected GraphQLObjectType objectType(@Nonnull String key) {
        GraphQLObjectType objectType = this._objectTypes.get(key);
        if (null == objectType) {
            String message = String.format("Unable to locate objectType '%s'. Please ensure it is defined prior to invoking objectType() method", key);
            throw new IllegalStateException(message);
        }
        return objectType;
    }

    @Nonnull
    protected DataFetcher wrapTopLevelDataFetcher(@Nonnull String key, boolean wrapInTransaction, @Nonnull ExceptingDataFetcher base) {
        return this.wrapTopLevelRawDataFetcher(key, wrapInTransaction, base.toDataFetcher());
    }

    @Nonnull
    protected DataFetcher wrapTopLevelRawDataFetcher(@Nonnull String key, boolean wrapInTransaction, @Nonnull DataFetcher fetcher) {
        DataFetcher wrapped = wrapInTransaction ? this.wrapInTransaction(key, fetcher) : fetcher;
        return (DataFetcher)this.getContextService().createContextualProxy((Object)wrapped, DataFetcher.class);
    }

    @Nonnull
    protected DataFetcher wrapInTransaction(@Nonnull String key, @Nonnull DataFetcher fetcher) {
        return new TransactionEnabledDataFetcher(this.getTransactionManager(), fetcher);
    }

    @Nonnull
    protected abstract TransactionManager getTransactionManager();

    @Nonnull
    protected abstract ContextService getContextService();
}

