/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.realityforge.graphql.domgen.WrapperRuntimeException;
import org.realityforge.replicant.server.EntityMessageEndpoint;
import org.realityforge.replicant.server.ee.ReplicantContextHolder;
import org.realityforge.replicant.server.ee.ReplicationRequestUtil;

public class ReplicantEnabledDataFetcher
implements DataFetcher {
    private final EntityMessageEndpoint _endpoint;
    private final EntityManager _entityManager;
    private final TransactionSynchronizationRegistry _registry;
    private final String _name;
    private final DataFetcher _fetcher;

    public ReplicantEnabledDataFetcher(@Nonnull EntityMessageEndpoint endpoint, @Nonnull EntityManager entityManager, @Nonnull TransactionSynchronizationRegistry registry, @Nonnull String name, @Nonnull DataFetcher fetcher) {
        this._endpoint = Objects.requireNonNull(endpoint);
        this._entityManager = Objects.requireNonNull(entityManager);
        this._registry = Objects.requireNonNull(registry);
        this._name = Objects.requireNonNull(name);
        this._fetcher = Objects.requireNonNull(fetcher);
    }

    public Object get(DataFetchingEnvironment environment) {
        String sessionID = (String)ReplicantContextHolder.remove((String)"SessionID");
        String requestID = (String)ReplicantContextHolder.remove((String)"RequestID");
        try {
            return ReplicationRequestUtil.runRequest((TransactionSynchronizationRegistry)this._registry, (EntityManager)this._entityManager, (EntityMessageEndpoint)this._endpoint, (String)this._name, (String)sessionID, (String)requestID, () -> this._fetcher.get(environment));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrapperRuntimeException(e);
        }
    }
}

