/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.servlet.AbstractGraphQLHttpServlet;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLSchemaProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.annotation.Nonnull;
import javax.persistence.NoResultException;
import org.realityforge.graphql.domgen.DataFetchingError;
import org.realityforge.graphql.domgen.ValidationError;
import org.realityforge.graphql.domgen.WrapperRuntimeException;

public abstract class AbstractDomgenGraphQLEndpoint
extends AbstractGraphQLHttpServlet {
    @Nonnull
    private final GraphQLQueryInvoker _invoker = GraphQLQueryInvoker.newBuilder().build();
    @Nonnull
    private final GraphQLInvocationInputFactory _invocationInputFactory = GraphQLInvocationInputFactory.newBuilder(this::getSchemaProvider).build();
    @Nonnull
    private final GraphQLObjectMapper _mapper = GraphQLObjectMapper.newBuilder().build();

    @Nonnull
    protected abstract GraphQLSchemaProvider getSchemaProvider();

    @Nonnull
    protected GraphQLQueryInvoker getQueryInvoker() {
        return this._invoker;
    }

    @Nonnull
    protected GraphQLInvocationInputFactory getInvocationInputFactory() {
        return this._invocationInputFactory;
    }

    protected GraphQLObjectMapper getGraphQLObjectMapper() {
        return this._mapper;
    }

    @Nonnull
    protected GraphQLError wrapDataFetcherError(@Nonnull ExceptionWhileDataFetching e) {
        Throwable t = this.unwrap(e.getException());
        return this.throwableToError(t);
    }

    @Nonnull
    private GraphQLError throwableToError(@Nonnull Throwable t) {
        if (t instanceof NoResultException) {
            return new ValidationError("Failed to load expected entity in database");
        }
        return new DataFetchingError(this.getMessage(t));
    }

    @Nonnull
    protected String getMessage(@Nonnull Throwable t) {
        return "Exception while fetching data: " + t;
    }

    @Nonnull
    protected Throwable unwrap(@Nonnull Throwable root) {
        Throwable t = root;
        while (this.isWrapperException(t) && null != t.getCause()) {
            t = t.getCause();
        }
        return t;
    }

    protected boolean isWrapperException(@Nonnull Throwable t) {
        return t instanceof UndeclaredThrowableException || t instanceof InvocationTargetException || t instanceof WrapperRuntimeException;
    }
}

