/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.transaction.TransactionManager;
import org.realityforge.graphql.domgen.WrapperRuntimeException;

public class TransactionEnabledDataFetcher
implements DataFetcher {
    private final TransactionManager _transactionManager;
    private final DataFetcher _fetcher;

    public TransactionEnabledDataFetcher(@Nonnull TransactionManager transactionManager, @Nonnull DataFetcher fetcher) {
        this._transactionManager = Objects.requireNonNull(transactionManager);
        this._fetcher = Objects.requireNonNull(fetcher);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(DataFetchingEnvironment environment) {
        try {
            this._transactionManager.begin();
            try {
                Object object = this._fetcher.get(environment);
                return object;
            }
            catch (Exception e) {
                this._transactionManager.setRollbackOnly();
                throw e;
            }
            finally {
                if (0 == this._transactionManager.getStatus()) {
                    this._transactionManager.commit();
                } else {
                    this._transactionManager.rollback();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrapperRuntimeException(e);
        }
    }
}

