/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.DataFetcher;
import graphql.schema.idl.RuntimeWiring;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.GraphQLSchemaProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.enterprise.concurrent.ContextService;
import javax.transaction.TransactionManager;
import org.realityforge.graphql.domgen.GraphQLSchemaService;
import org.realityforge.graphql.domgen.SchemaUtil;
import org.realityforge.graphql.domgen.TransactionEnabledDataFetcher;

public abstract class AbstractGraphQLSchemaService
implements GraphQLSchemaService {
    @Nullable
    private GraphQLSchemaProvider _schemaProvider;

    protected void initSchemaProvider() {
        this._schemaProvider = new DefaultGraphQLSchemaProvider(SchemaUtil.buildGraphQLSchema(this.getSchemaResources(), this::wireSchema));
    }

    protected abstract void wireSchema(@Nonnull RuntimeWiring.Builder var1);

    @Override
    @Nonnull
    public GraphQLSchemaProvider getProvider() {
        assert (null != this._schemaProvider);
        return this._schemaProvider;
    }

    @Nonnull
    protected abstract List<String> getSchemaResources();

    @Nonnull
    protected DataFetcher topLevelDataFetcher(@Nonnull String key, boolean wrapInTransaction, @Nonnull DataFetcher fetcher) {
        DataFetcher dataFetcher = wrapInTransaction ? this.wrapInTransaction(key, fetcher) : fetcher;
        return (DataFetcher)this.getContextService().createContextualProxy((Object)dataFetcher, DataFetcher.class);
    }

    @Nonnull
    protected DataFetcher wrapInTransaction(@Nonnull String key, @Nonnull DataFetcher fetcher) {
        return new TransactionEnabledDataFetcher(this.getTransactionManager(), fetcher);
    }

    @Nonnull
    protected abstract TransactionManager getTransactionManager();

    @Nonnull
    protected abstract ContextService getContextService();
}

