/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.realityforge.replicant.server.EntityMessageEndpoint;
import org.realityforge.replicant.server.ee.ReplicantContextHolder;
import org.realityforge.replicant.server.ee.ReplicationRequestUtil;
import org.realityforge.replicant.server.transport.ReplicantSession;
import org.realityforge.replicant.server.transport.ReplicantSessionManager;

public class ReplicantEnabledDataFetcher
implements DataFetcher {
    @Nonnull
    private final ReplicantSessionManager _sessionManager;
    @Nonnull
    private final EntityMessageEndpoint _endpoint;
    @Nonnull
    private final EntityManager _entityManager;
    @Nonnull
    private final TransactionSynchronizationRegistry _registry;
    @Nonnull
    private final String _name;
    @Nonnull
    private final DataFetcher _fetcher;

    ReplicantEnabledDataFetcher(@Nonnull ReplicantSessionManager sessionManager, @Nonnull EntityMessageEndpoint endpoint, @Nonnull EntityManager entityManager, @Nonnull TransactionSynchronizationRegistry registry, @Nonnull String name, @Nonnull DataFetcher fetcher) {
        this._sessionManager = Objects.requireNonNull(sessionManager);
        this._endpoint = Objects.requireNonNull(endpoint);
        this._entityManager = Objects.requireNonNull(entityManager);
        this._registry = Objects.requireNonNull(registry);
        this._name = Objects.requireNonNull(name);
        this._fetcher = Objects.requireNonNull(fetcher);
    }

    public Object get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        String sessionId = (String)ReplicantContextHolder.remove((String)"SessionID");
        Integer requestId = (Integer)ReplicantContextHolder.remove((String)"RequestID");
        ReplicantSession session = null != sessionId ? this._sessionManager.getSession(sessionId) : null;
        return ReplicationRequestUtil.runRequest((TransactionSynchronizationRegistry)this._registry, (EntityManager)this._entityManager, (EntityMessageEndpoint)this._endpoint, (String)this._name, (ReplicantSession)session, (Integer)requestId, () -> this._fetcher.get(environment));
    }
}

