/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.validation.SchemaValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

final class SchemaUtil {
    private SchemaUtil() {
    }

    @Nonnull
    static GraphQLSchema buildGraphQLSchema(@Nonnull List<String> resources, @Nonnull Consumer<RuntimeWiring.Builder> action) {
        SchemaParser schemaParser = new SchemaParser();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        for (String resourceName : resources) {
            try {
                InputStream inputStream = SchemaUtil.class.getResourceAsStream(resourceName);
                Throwable throwable = null;
                try {
                    if (null == inputStream) {
                        throw new IllegalStateException("Attempting to load resource named '" + resourceName + "' to populate the GraphQL type definition registry but the resource does not exist on the classpath.");
                    }
                    typeRegistry.merge(schemaParser.parse((Reader)new InputStreamReader(inputStream)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Attempting to load resource named '" + resourceName + "' to populate the GraphQL type definition registry but there was an error loading the resource from the classpath: " + ioe, ioe);
            }
        }
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        action.accept(builder);
        GraphQLSchema schema = schemaGenerator.makeExecutableSchema(typeRegistry, builder.build());
        new SchemaValidator().validateSchema(schema);
        return schema;
    }
}

