/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.transaction.TransactionManager;

public class TransactionEnabledDataFetcher
implements DataFetcher {
    private final TransactionManager _transactionManager;
    private final DataFetcher _fetcher;

    public TransactionEnabledDataFetcher(@Nonnull TransactionManager transactionManager, @Nonnull DataFetcher fetcher) {
        this._transactionManager = Objects.requireNonNull(transactionManager);
        this._fetcher = Objects.requireNonNull(fetcher);
    }

    public Object get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        this._transactionManager.begin();
        try {
            Object object = this._fetcher.get(environment);
            return object;
        }
        catch (Exception e) {
            this._transactionManager.setRollbackOnly();
            throw e;
        }
        finally {
            if (0 == this._transactionManager.getStatus()) {
                this._transactionManager.commit();
            } else {
                this._transactionManager.rollback();
            }
        }
    }
}

