/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.graphql.domgen;

import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Nonnull;

public final class Scalars {
    public static GraphQLScalarType DATE_TIME = GraphQLScalarType.newScalar().name("DateTime").description("DataTime scalar").coercing((Coercing)new DateTimeCoercing()).build();
    public static GraphQLScalarType DATE = GraphQLScalarType.newScalar().name("Date").description("Date scalar").coercing((Coercing)new DateCoercing()).build();

    private static class DateCoercing
    implements Coercing<Date, String> {
        private DateCoercing() {
        }

        public String serialize(Object input) {
            try {
                Date date = (Date)input;
                return date.toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (Exception e) {
                throw new CoercingSerializeException("Failed to serialize value " + input + " as a date.");
            }
        }

        public Date parseValue(Object input) {
            if (input instanceof StringValue) {
                String value = ((StringValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in the ISO local date format, such as '2011-12-03'";
                    throw new CoercingParseValueException(message);
                }
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in milliseconds since Epoch";
                    throw new CoercingParseValueException(message);
                }
            }
            if (input instanceof NullValue) {
                return null;
            }
            String message = "Error parsing literal " + input + " as it is the incorrect type. Expected a string or an integer.";
            throw new CoercingParseValueException(message);
        }

        public Date parseLiteral(Object input) {
            if (input instanceof StringValue) {
                String value = ((StringValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in the ISO local date format, such as '2011-12-03'";
                    throw new CoercingParseLiteralException(message);
                }
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in milliseconds since Epoch";
                    throw new CoercingParseLiteralException(message);
                }
            }
            if (input instanceof NullValue) {
                return null;
            }
            String message = "Error parsing literal " + input + " as it is the incorrect type. Expected a string or an integer.";
            throw new CoercingParseLiteralException(message);
        }

        @Nonnull
        private Date parseDate(@Nonnull BigInteger value) {
            long epochMilli = value.longValue();
            return Date.from(Instant.ofEpochMilli(epochMilli));
        }

        @Nonnull
        private Date parseDate(@Nonnull String value) {
            return Date.from(LocalDate.parse(value).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    private static class DateTimeCoercing
    implements Coercing<Date, String> {
        private DateTimeCoercing() {
        }

        public String serialize(Object input) {
            try {
                Date date = (Date)input;
                return date.toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (Exception e) {
                throw new CoercingSerializeException("Failed to serialize value " + input + " as a date-time");
            }
        }

        public Date parseValue(Object input) {
            if (input instanceof StringValue) {
                String value = ((StringValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing value '" + value + "'. Expected to be in the ISO date-time format with an offset, such as '2011-12-03T10:15:30+01:00'";
                    throw new CoercingParseValueException(message);
                }
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing value '" + value + "'. Expected to be in milliseconds since Epoch";
                    throw new CoercingParseValueException(message);
                }
            }
            if (input instanceof NullValue) {
                return null;
            }
            String message = "Error parsing value " + input + " as it is the incorrect type. Expected a string or an integer.";
            throw new CoercingParseValueException(message);
        }

        public Date parseLiteral(Object input) {
            if (input instanceof StringValue) {
                String value = ((StringValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in the ISO date-time format with an offset, such as '2011-12-03T10:15:30+01:00'";
                    throw new CoercingParseLiteralException(message);
                }
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                try {
                    return this.parseDate(value);
                }
                catch (Throwable t) {
                    String message = "Error parsing literal '" + value + "'. Expected to be in milliseconds since Epoch";
                    throw new CoercingParseLiteralException(message);
                }
            }
            if (input instanceof NullValue) {
                return null;
            }
            String message = "Error parsing literal " + input + " as it is the incorrect type. Expected a string or an integer.";
            throw new CoercingParseLiteralException(message);
        }

        @Nonnull
        private Date parseDate(@Nonnull BigInteger value) {
            long epochMilli = value.longValue();
            return Date.from(Instant.ofEpochMilli(epochMilli));
        }

        @Nonnull
        private Date parseDate(@Nonnull String value) {
            return Date.from(ZonedDateTime.parse(value).toInstant());
        }
    }
}

