/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.keycloak.domgen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.naming.InitialContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;
import org.realityforge.keycloak.domgen.JndiUtil;

public abstract class AbstractJndiBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    private ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private KeycloakDeployment _deployment;

    @Nonnull
    protected abstract String getRootJndiPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeycloakDeployment resolve(HttpFacade.Request request) {
        this._lock.readLock().lock();
        if (null != this._deployment) {
            return this._deployment;
        }
        this._lock.readLock().unlock();
        this._lock.writeLock().lock();
        try {
            this._deployment = this.buildKeycloakDeployment();
        }
        finally {
            this._lock.writeLock().unlock();
        }
        return this._deployment;
    }

    @Nonnull
    private KeycloakDeployment buildKeycloakDeployment() {
        try {
            JsonObject object = JndiUtil.buildJsonFromContext(new InitialContext(), this.getRootJndiPath());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Json.createWriter((OutputStream)baos).write((JsonStructure)object);
            baos.close();
            return KeycloakDeploymentBuilder.build((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to build deployment configuration", e);
        }
    }
}

