/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.keycloak.domgen;

import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

final class JndiUtil {
    private JndiUtil() {
    }

    @Nonnull
    static JsonObject buildJsonFromContext(@Nonnull Context context, @Nonnull String path) throws NamingException {
        JsonObjectBuilder object = Json.createObjectBuilder();
        NamingEnumeration<NameClassPair> enumeration = context.list(path);
        while (enumeration.hasMore()) {
            NameClassPair pair = enumeration.next();
            String key = pair.getName();
            String subpath = path + "/" + key;
            Object value = context.lookup(subpath);
            if (null == value) {
                object.addNull(key);
                continue;
            }
            if (String.class.isInstance(value)) {
                object.add(key, (String)value);
                continue;
            }
            if (Boolean.class.isInstance(value)) {
                object.add(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (Integer.class.isInstance(value)) {
                object.add(key, ((Integer)value).intValue());
                continue;
            }
            if (Short.class.isInstance(value)) {
                object.add(key, (int)((Short)value).shortValue());
                continue;
            }
            if (Long.class.isInstance(value)) {
                object.add(key, ((Long)value).longValue());
                continue;
            }
            if (Float.class.isInstance(value)) {
                object.add(key, (double)((Float)value).floatValue());
                continue;
            }
            if (Double.class.isInstance(value)) {
                object.add(key, ((Double)value).doubleValue());
                continue;
            }
            if (!Context.class.isInstance(value)) continue;
            Context subcontext = (Context)value;
            object.add(key, (JsonValue)JndiUtil.buildJsonFromContext(subcontext, subpath));
        }
        enumeration.close();
        return object.build();
    }
}

