/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.keycloak.domgen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.naming.InitialContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;
import org.realityforge.keycloak.domgen.JndiUtil;

public abstract class AbstractJndiBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    @Nonnull
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    @Nullable
    private KeycloakDeployment _deployment;

    @Nonnull
    protected abstract String getRootJndiPath();

    protected abstract void customizeConfiguration(@Nonnull JsonObjectBuilder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeycloakDeployment resolve(@Nonnull HttpFacade.Request request) {
        this._lock.readLock().lock();
        try {
            if (null != this._deployment) {
                KeycloakDeployment keycloakDeployment = this._deployment;
                return keycloakDeployment;
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        this._lock.writeLock().lock();
        try {
            this._deployment = this.buildKeycloakDeployment();
        }
        finally {
            this._lock.writeLock().unlock();
        }
        return this._deployment;
    }

    @Nonnull
    private KeycloakDeployment buildKeycloakDeployment() {
        try {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            JndiUtil.buildJsonFromContext(builder, new InitialContext(), this.getRootJndiPath());
            this.customizeConfiguration(builder);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Json.createWriter((OutputStream)baos).write((JsonStructure)builder.build());
            baos.close();
            return KeycloakDeploymentBuilder.build((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to build deployment configuration", e);
        }
    }
}

