/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.keycloak.domgen;

import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class JndiUtil {
    private JndiUtil() {
    }

    @Nonnull
    public static JsonObject buildJsonFromContext(@Nonnull Context context, @Nonnull String path) throws NamingException {
        JsonObjectBuilder object = Json.createObjectBuilder();
        JndiUtil.buildJsonFromContext(object, context, path);
        return object.build();
    }

    public static void buildJsonFromContext(@Nonnull JsonObjectBuilder builder, @Nonnull Context context, @Nonnull String path) throws NamingException {
        NamingEnumeration<NameClassPair> enumeration = context.list(path);
        while (enumeration.hasMore()) {
            NameClassPair pair = enumeration.next();
            String key = pair.getName();
            String subpath = path + "/" + key;
            Object value = context.lookup(subpath);
            if (null == value) {
                builder.addNull(key);
                continue;
            }
            if (value instanceof String) {
                builder.add(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                builder.add(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                builder.add(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Short) {
                builder.add(key, (int)((Short)value).shortValue());
                continue;
            }
            if (value instanceof Long) {
                builder.add(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                builder.add(key, (double)((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                builder.add(key, ((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof Context)) continue;
            Context subcontext = (Context)value;
            builder.add(key, (JsonValue)JndiUtil.buildJsonFromContext(subcontext, subpath));
        }
        enumeration.close();
    }
}

