/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.keycloak.sks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.realityforge.keycloak.sks.MissingKeycloakAccountException;
import org.realityforge.keycloak.sks.SimpleAuthService;

@ApplicationScoped
@Typed(value={SimpleAuthService.class})
public class SimplAuthServiceImpl
implements SimpleAuthService {
    @Inject
    private HttpServletRequest _httpRequest;

    @Override
    @Nullable
    public OidcKeycloakAccount findAccount() {
        OidcKeycloakAccount account = (OidcKeycloakAccount)this._httpRequest.getAttribute(KeycloakAccount.class.getName());
        if (null == account) {
            HttpSession session = this._httpRequest.getSession(false);
            if (null != session) {
                return (OidcKeycloakAccount)session.getAttribute(KeycloakAccount.class.getName());
            }
            return null;
        }
        return account;
    }

    @Override
    @Nonnull
    public OidcKeycloakAccount getAccount() {
        OidcKeycloakAccount account = this.findAccount();
        if (null == account) {
            throw new MissingKeycloakAccountException();
        }
        return account;
    }
}

