/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.proton.qa;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubject;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileObject;
import org.testng.Assert;

public abstract class AbstractProcessorTest {
    protected final void assertSuccessfulCompile(@Nonnull String classname, String ... expectedOutputResources) throws Exception {
        this.assertSuccessfulCompile(this.inputs(classname), Arrays.asList(expectedOutputResources));
    }

    protected final void assertSuccessfulCompile(@Nonnull List<JavaFileObject> inputs, @Nonnull List<String> outputs) throws Exception {
        this.assertSuccessfulCompile(inputs, outputs, this::emitGeneratedFile);
    }

    protected final void assertSuccessfulCompile(@Nonnull List<JavaFileObject> inputs, @Nonnull List<String> outputs, @Nonnull Predicate<JavaFileObject> filter) throws Exception {
        JavaFileObject[] restExpected;
        JavaFileObject firstExpected;
        if (this.outputFiles()) {
            Field field;
            ArrayList<Processor> processors = new ArrayList<Processor>();
            processors.add(this.processor());
            processors.addAll(Arrays.asList(this.additionalProcessors()));
            Compilation compilation = Compiler.javac().withProcessors(processors).withOptions(this.getOptions()).compile(inputs);
            Compilation.Status status = compilation.status();
            if (Compilation.Status.SUCCESS != status) {
                field = compilation.getClass().getDeclaredField("status");
                field.setAccessible(true);
                field.set(compilation, Compilation.Status.SUCCESS);
            }
            this.outputGeneratedFiles(compilation, filter);
            if (Compilation.Status.SUCCESS != status) {
                field = compilation.getClass().getDeclaredField("status");
                field.setAccessible(true);
                field.set(compilation, status);
                compilation.generatedSourceFiles();
            }
        }
        List sourceFiles = outputs.stream().filter(o -> o.endsWith(".java")).collect(Collectors.toList());
        List otherFiles = outputs.stream().filter(o -> !o.endsWith(".java")).collect(Collectors.toList());
        CompileTester.CleanCompilationClause clause = this.assertCompilesWithoutWarnings(inputs);
        if (!sourceFiles.isEmpty()) {
            firstExpected = this.fixture((String)sourceFiles.get(0));
            restExpected = (JavaFileObject[])sourceFiles.stream().skip(1L).map(this::fixture).toArray(JavaFileObject[]::new);
            ((CompileTester.GeneratedPredicateClause)clause.and()).generatesSources(firstExpected, restExpected);
        }
        if (!otherFiles.isEmpty()) {
            firstExpected = this.fixture((String)otherFiles.get(0));
            restExpected = (JavaFileObject[])otherFiles.stream().skip(1L).map(this::fixture).toArray(JavaFileObject[]::new);
            ((CompileTester.GeneratedPredicateClause)clause.and()).generatesFiles(firstExpected, restExpected);
        }
    }

    private void outputGeneratedFiles(@Nonnull Compilation compilation, @Nonnull Predicate<JavaFileObject> filter) throws IOException {
        for (JavaFileObject fileObject : compilation.generatedFiles()) {
            if (!filter.test(fileObject)) continue;
            String filename = fileObject.getName().replace("/SOURCE_OUTPUT/", "").replace("/CLASS_OUTPUT/", "");
            this.outputGeneratedFile(fileObject, this.fixtureDir().resolve("expected/" + filename));
        }
    }

    private void outputGeneratedFile(@Nonnull JavaFileObject fileObject, @Nonnull Path target) throws IOException {
        File dir = target.getParent().toFile();
        if (!dir.exists()) {
            Assert.assertTrue((boolean)dir.mkdirs());
        }
        if (!Files.exists(target, new LinkOption[0]) || !this.doesTargetFileMatchGenerated(fileObject, target)) {
            Files.copy(fileObject.openInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private boolean doesTargetFileMatchGenerated(@Nonnull JavaFileObject fileObject, @Nonnull Path target) throws IOException {
        byte[] existing = Files.readAllBytes(target);
        InputStream generated = fileObject.openInputStream();
        byte[] data = new byte[generated.available()];
        Assert.assertEquals((int)generated.read(data), (int)data.length);
        return Arrays.equals(existing, data);
    }

    @Nonnull
    protected final CompileTester assertCompiles(@Nonnull List<JavaFileObject> inputs) {
        return ((JavaSourcesSubject)Truth.assert_().about((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that(inputs)).withCompilerOptions(this.getOptions()).processedWith(this.processor(), this.additionalProcessors());
    }

    @Nonnull
    protected final CompileTester.SuccessfulCompilationClause assertCompilesWithoutErrors(@Nonnull String classname) {
        return this.assertCompilesWithoutErrors(this.inputs(classname));
    }

    @Nonnull
    protected final List<JavaFileObject> inputs(String ... classnames) {
        return Stream.of(classnames).map(classname -> this.fixture(this.toFilename("input", (String)classname))).collect(Collectors.toList());
    }

    @Nonnull
    protected final CompileTester.SuccessfulCompilationClause assertCompilesWithoutErrors(@Nonnull List<JavaFileObject> inputs) {
        return this.assertCompiles(inputs).compilesWithoutError();
    }

    @Nonnull
    protected final CompileTester.CleanCompilationClause assertCompilesWithoutWarnings(@Nonnull String classname) {
        return this.assertCompilesWithoutWarnings(this.inputs(classname));
    }

    @Nonnull
    protected final CompileTester.CleanCompilationClause assertCompilesWithoutWarnings(@Nonnull List<JavaFileObject> inputs) {
        return this.assertCompiles(inputs).compilesWithoutWarnings();
    }

    protected final void assertCompilesWithSingleWarning(@Nonnull String classname, @Nonnull String messageFragment) {
        ((CompileTester.SuccessfulCompilationClause)this.assertCompilesWithoutErrors(classname).withWarningCount(1)).withWarningContaining(messageFragment);
    }

    protected boolean emitGeneratedFile(@Nonnull JavaFileObject target) {
        return JavaFileObject.Kind.CLASS != target.getKind();
    }

    @Nonnull
    protected abstract Processor processor();

    @Nonnull
    protected List<String> getOptions() {
        return Arrays.asList("-Xlint:all,-processing", "-implicit:none", "-A" + this.getOptionPrefix() + ".defer.errors=false");
    }

    protected final void assertFailedCompile(@Nonnull String classname, @Nonnull String errorMessageFragment) {
        this.assertFailedCompileResource(this.toFilename("bad_input", classname), errorMessageFragment);
    }

    @Nonnull
    protected final String toFilename(@Nonnull String dir, @Nonnull String classname) {
        return this.toFilename(dir, classname, "", ".java");
    }

    @Nonnull
    protected final String toFilename(@Nonnull String dir, @Nonnull String classname, @Nonnull String prefix, @Nonnull String postfix) {
        String[] stringArray;
        if (classname.contains(".")) {
            stringArray = classname.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = classname;
        }
        String[] elements = stringArray;
        StringBuilder input = new StringBuilder();
        input.append(dir);
        for (int i = 0; i < elements.length; ++i) {
            boolean lastElement = i == elements.length - 1;
            input.append('/');
            if (lastElement) {
                input.append(prefix);
            }
            input.append(elements[i]);
            if (!lastElement) continue;
            input.append(postfix);
        }
        return input.toString();
    }

    protected final void assertFailedCompileResource(@Nonnull String inputResource, @Nonnull String errorMessageFragment) {
        this.assertFailedCompileResource(Collections.singletonList(this.fixture(inputResource)), errorMessageFragment);
    }

    protected final void assertFailedCompileResource(@Nonnull List<JavaFileObject> inputs, @Nonnull String errorMessageFragment) {
        ((JavaSourcesSubject)Truth.assert_().about((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that(inputs)).withCompilerOptions(this.getOptions()).processedWith(this.processor(), this.additionalProcessors()).failsToCompile().withErrorContaining(errorMessageFragment);
    }

    @Nonnull
    protected Processor[] additionalProcessors() {
        return new Processor[0];
    }

    @Nonnull
    protected final JavaFileObject fixture(@Nonnull String filename) {
        Path path = this.fixtureDir().resolve(filename);
        if (!Files.exists(path, new LinkOption[0])) {
            Assert.fail((String)("Fixture " + path + " does not exist."));
        }
        try {
            return JavaFileObjects.forResource((URL)path.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    protected final Path fixtureDir() {
        String key = this.getOptionPrefix() + this.getFixtureKeyPart() + ".fixture_dir";
        String fixtureDir = System.getProperty(key);
        Assert.assertNotNull((Object)fixtureDir, (String)("Expected System.getProperty( \"" + key + "\" ) to return fixture directory"));
        return new File(fixtureDir).toPath();
    }

    @Nonnull
    protected String getFixtureKeyPart() {
        return "";
    }

    @Nonnull
    protected abstract String getOptionPrefix();

    protected final boolean outputFiles() {
        return System.getProperty(this.getOptionPrefix() + ".output_fixture_data", "false").equals("true");
    }
}

