/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.proton.qa;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
final class SynthesizingProcessor
extends AbstractProcessor {
    @Nonnull
    private final String _classname;
    @Nonnull
    private final String _source;
    private final int _targetRound;
    private int _round;

    SynthesizingProcessor(@Nonnull String classname, @Nonnull String source, int targetRound) {
        this._classname = Objects.requireNonNull(classname);
        this._source = Objects.requireNonNull(source);
        this._targetRound = targetRound;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block14: {
            try {
                if (this._targetRound != this._round) break block14;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Synthesizing " + this._classname + " in round " + this._round);
                JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(this._classname, new Element[0]);
                try (Writer writer = sourceFile.openWriter();){
                    writer.write(this._source);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error occurred synthesizing files: " + e);
            }
        }
        ++this._round;
        return false;
    }
}

