/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.rest.criteria;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.realityforge.rest.criteria.RestCriteriaExprBaseListener;
import org.realityforge.rest.criteria.RestCriteriaExprLexer;
import org.realityforge.rest.criteria.RestCriteriaExprParser;
import org.realityforge.rest.criteria.model.AtomicCondition;
import org.realityforge.rest.criteria.model.BinaryCondition;
import org.realityforge.rest.criteria.model.Condition;
import org.realityforge.rest.criteria.model.ConstantExpression;
import org.realityforge.rest.criteria.model.Element;
import org.realityforge.rest.criteria.model.Expression;
import org.realityforge.rest.criteria.model.UnaryCondition;
import org.realityforge.rest.criteria.model.VariableExpression;

public final class CriteriaParser {
    private Condition _condition;

    public CriteriaParser(@Nonnull String criteria) {
        try {
            ANTLRInputStream input = new ANTLRInputStream((Reader)new StringReader(criteria));
            BailLexer lexer = new BailLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            RestCriteriaExprParser parser = new RestCriteriaExprParser((TokenStream)tokens);
            parser.setBuildParseTree(true);
            ParseListener listener = new ParseListener();
            parser.addParseListener(listener);
            parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            parser.top_level_condition();
            this._condition = listener.getCondition();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Poorly formatted criteria: " + criteria, ioe);
        }
    }

    public Condition getCondition() {
        return this._condition;
    }

    private static class ParseListener
    extends RestCriteriaExprBaseListener {
        private final Stack<Element> _stack = new Stack();
        private Condition _condition;

        private ParseListener() {
        }

        Condition getCondition() {
            return this._condition;
        }

        @Override
        public void exitTop_level_condition(@NotNull RestCriteriaExprParser.Top_level_conditionContext ctx) {
            if (this.isInError(ctx)) {
                return;
            }
            if (1 != this._stack.size()) {
                throw new IllegalStateException("Expected to complete with a single expression on stack");
            }
            this._condition = (Condition)this._stack.pop();
        }

        @Override
        public void exitCondition(@NotNull RestCriteriaExprParser.ConditionContext ctx) {
            if (this.isInError(ctx)) {
                return;
            }
            if (null != ctx.op) {
                Condition rhs = (Condition)this._stack.pop();
                if (null != ctx.NOT()) {
                    this._stack.push(new UnaryCondition(UnaryCondition.Operator.NOT, rhs));
                } else {
                    Condition lhs = (Condition)this._stack.pop();
                    if (null != ctx.AND()) {
                        this._stack.push(new BinaryCondition(BinaryCondition.Operator.AND, lhs, rhs));
                    } else if (null != ctx.OR()) {
                        this._stack.push(new BinaryCondition(BinaryCondition.Operator.OR, lhs, rhs));
                    } else {
                        throw new IllegalStateException("Unknown operation: " + ctx.op);
                    }
                }
            }
        }

        @Override
        public void exitAtomic_condition(@NotNull RestCriteriaExprParser.Atomic_conditionContext ctx) {
            if (this.isInError(ctx)) {
                return;
            }
            Expression rhs = (Expression)this._stack.pop();
            VariableExpression lhs = (VariableExpression)this._stack.pop();
            if (ctx.op.getType() == 4) {
                this._stack.push(new AtomicCondition(AtomicCondition.Operator.EQUALS, lhs, rhs));
            } else if (ctx.op.getType() == 5) {
                this._stack.push(new AtomicCondition(AtomicCondition.Operator.NOT_EQUALS, lhs, rhs));
            } else {
                throw new IllegalStateException("Unknown operation: " + ctx.op);
            }
        }

        @Override
        public void exitExpr(@NotNull RestCriteriaExprParser.ExprContext ctx) {
            if (this.isInError(ctx)) {
                return;
            }
            if (null != ctx.INT()) {
                try {
                    this._stack.push(new ConstantExpression(Integer.parseInt(ctx.INT().getText())));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("Error parsing integer", nfe);
                }
            } else if (null != ctx.BOOLEAN()) {
                this._stack.push(new ConstantExpression("true".equals(ctx.BOOLEAN().getText())));
            } else if (null != ctx.STRING()) {
                String text = ctx.STRING().getText();
                this._stack.push(new ConstantExpression(text.substring(1, text.length() - 1)));
            } else {
                throw new IllegalStateException("Error handling expression");
            }
        }

        @Override
        public void exitVar_expr(@NotNull RestCriteriaExprParser.Var_exprContext ctx) {
            if (this.isInError(ctx)) {
                return;
            }
            List<TerminalNode> ids = ctx.ID();
            ArrayList<String> elements = new ArrayList<String>();
            for (TerminalNode id : ids) {
                String element = id.getText();
                elements.add(element);
            }
            this._stack.push(new VariableExpression(elements.toArray(new String[elements.size()])));
        }

        private boolean isInError(ParserRuleContext ctx) {
            return null != ctx.exception || null == ctx.stop;
        }
    }

    private static class BailLexer
    extends RestCriteriaExprLexer {
        public BailLexer(CharStream input) {
            super(input);
        }

        public void recover(LexerNoViableAltException e) {
            throw new ParseCancellationException((Throwable)e);
        }
    }
}

