/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.rest.criteria.jpa;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.realityforge.rest.criteria.CriteriaParser;
import org.realityforge.rest.criteria.jpa.BadConditionException;
import org.realityforge.rest.criteria.model.AtomicCondition;
import org.realityforge.rest.criteria.model.BinaryCondition;
import org.realityforge.rest.criteria.model.Condition;
import org.realityforge.rest.criteria.model.ConstantExpression;
import org.realityforge.rest.criteria.model.UnaryCondition;
import org.realityforge.rest.criteria.model.VariableExpression;

public abstract class AbstractQueryBuilder<T> {
    private final CriteriaQuery<T> _criteriaQuery;
    private final CriteriaBuilder _cb;
    private final Root<T> _root;
    private final LinkedList<ParameterSetter<T>> _parameterSetters = new LinkedList();

    protected AbstractQueryBuilder(@Nonnull Class<T> type, @Nonnull CriteriaBuilder cb, @Nullable String input) {
        this._cb = cb;
        this._criteriaQuery = this._cb.createQuery(type);
        this._root = this._criteriaQuery.from(type);
        this._criteriaQuery.select(this._root);
        this.applyRestrictions(input);
    }

    protected void applyRestrictions(@Nullable String input) {
        if (null != input && !"".equals(input.trim())) {
            this._criteriaQuery.where((Expression)this.parse(input));
        }
    }

    protected Root<T> getRoot() {
        return this._root;
    }

    public final CriteriaQuery<T> getCriteriaQuery() {
        return this._criteriaQuery;
    }

    public final void applyParameters(@Nonnull TypedQuery<T> query) {
        for (ParameterSetter parameterSetter : this._parameterSetters) {
            parameterSetter.apply(query);
        }
    }

    protected final Predicate parse(String criteria) {
        CriteriaParser parser = new CriteriaParser(criteria);
        Condition condition = parser.getCondition();
        return this.processCondition(condition);
    }

    private Predicate processCondition(Condition condition) {
        if (condition instanceof AtomicCondition) {
            return this.processAtomicCondition((AtomicCondition)condition);
        }
        if (condition instanceof BinaryCondition) {
            return this.processBinaryCondition((BinaryCondition)condition);
        }
        if (condition instanceof UnaryCondition) {
            return this.processUnaryCondition((UnaryCondition)condition);
        }
        throw new BadConditionException("Invalid condition");
    }

    private Predicate processAtomicCondition(AtomicCondition condition) {
        Expression<?> lhsExpression = this.processVariableExpression(condition.getLhs());
        Expression<?> rhsExpression = this.processExpression(condition.getRhs());
        switch (condition.getOperator()) {
            case EQUALS: {
                return this._cb.equal(lhsExpression, rhsExpression);
            }
            case NOT_EQUALS: {
                return this._cb.notEqual(lhsExpression, rhsExpression);
            }
        }
        throw new BadConditionException("Invalid operator");
    }

    private Expression<?> processExpression(org.realityforge.rest.criteria.model.Expression expression) {
        if (expression instanceof ConstantExpression) {
            return this.processConstantExpression((ConstantExpression)expression);
        }
        if (expression instanceof VariableExpression) {
            return this.processVariableExpression((VariableExpression)expression);
        }
        throw new BadConditionException("Invalid expression");
    }

    private Expression<?> processConstantExpression(final ConstantExpression expression) {
        if (expression.isBoolean()) {
            final ParameterExpression p = this._cb.parameter(Boolean.class);
            this._parameterSetters.add(new ParameterSetter<T>(){

                @Override
                public void apply(TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asBoolean());
                }
            });
            return p;
        }
        if (expression.isNumeric()) {
            final ParameterExpression p = this._cb.parameter(Number.class);
            this._parameterSetters.add(new ParameterSetter<T>(){

                @Override
                public void apply(TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asNumeric());
                }
            });
            return p;
        }
        if (expression.isText()) {
            final ParameterExpression p = this._cb.parameter(String.class);
            this._parameterSetters.add(new ParameterSetter<T>(){

                @Override
                public void apply(TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asText());
                }
            });
            return p;
        }
        throw new BadConditionException("Invalid constant expression: " + expression.getValue());
    }

    protected abstract Expression<?> processVariableExpression(@Nonnull VariableExpression var1);

    private Predicate processBinaryCondition(BinaryCondition condition) {
        Predicate lhsPredicate = this.processCondition(condition.getLhs());
        Predicate rhsPredicate = this.processCondition(condition.getRhs());
        switch (condition.getOperator()) {
            case AND: {
                return this._cb.and((Expression)lhsPredicate, (Expression)rhsPredicate);
            }
            case OR: {
                return this._cb.or((Expression)lhsPredicate, (Expression)rhsPredicate);
            }
        }
        throw new BadConditionException("Invalid binary operator");
    }

    private Predicate processUnaryCondition(UnaryCondition condition) {
        switch (condition.getOperator()) {
            case NOT: {
                return this._cb.not((Expression)this.processCondition(condition.getCondition()));
            }
        }
        throw new BadConditionException("Invalid unary operator");
    }

    private static interface ParameterSetter<T> {
        public void apply(TypedQuery<T> var1);
    }
}

