/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.rest.criteria.model;

import javax.annotation.Nonnull;
import org.realityforge.rest.criteria.model.Expression;

public class ConstantExpression
extends Expression {
    private final Object _value;

    public ConstantExpression(@Nonnull Object value) {
        this._value = value;
        if (!(this.isText() || this.isBoolean() || this.isNumeric())) {
            throw new IllegalArgumentException();
        }
    }

    public Object getValue() {
        return this._value;
    }

    public boolean isBoolean() {
        return this._value instanceof Boolean;
    }

    public boolean isNumeric() {
        return this._value instanceof Number;
    }

    public boolean isText() {
        return this._value instanceof String;
    }

    public Boolean asBoolean() {
        if (!this.isBoolean()) {
            throw new IllegalStateException();
        }
        return (Boolean)this._value;
    }

    public Number asNumeric() {
        if (!this.isNumeric()) {
            throw new IllegalStateException();
        }
        return (Number)this._value;
    }

    public String asText() {
        if (!this.isText()) {
            throw new IllegalStateException();
        }
        return (String)this._value;
    }
}

