/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.rest.criteria.jpa;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.realityforge.rest.criteria.CriteriaParser;
import org.realityforge.rest.criteria.jpa.BadConditionException;
import org.realityforge.rest.criteria.model.AtomicCondition;
import org.realityforge.rest.criteria.model.BinaryCondition;
import org.realityforge.rest.criteria.model.Condition;
import org.realityforge.rest.criteria.model.ConstantExpression;
import org.realityforge.rest.criteria.model.UnaryCondition;
import org.realityforge.rest.criteria.model.VariableExpression;

public abstract class AbstractQueryBuilder<T> {
    private final CriteriaQuery<T> _criteriaQuery;
    private final CriteriaBuilder _cb;
    private final Root<T> _root;
    private final LinkedList<ParameterSetter<T>> _parameterSetters = new LinkedList();

    protected AbstractQueryBuilder(@Nonnull Class<T> type, @Nonnull CriteriaBuilder cb, @Nullable String input) {
        this._cb = cb;
        this._criteriaQuery = this._cb.createQuery(type);
        this._root = this._criteriaQuery.from(type);
        this._criteriaQuery.select(this._root);
        this.applyRestrictions(input);
    }

    @Nonnull
    protected final CriteriaBuilder getCriteriaBuilder() {
        return this._cb;
    }

    protected final void applyRestrictions(@Nullable String input) {
        if (null != input && !"".equals(input.trim())) {
            this.applyRestriction(this.parse(input));
        } else {
            this.applyRestriction(null);
        }
    }

    protected void applyRestriction(@Nullable Predicate predicate) {
        if (null != predicate) {
            this._criteriaQuery.where((Expression)predicate);
        }
    }

    @Nonnull
    protected Root<T> getRoot() {
        return this._root;
    }

    @Nonnull
    public final CriteriaQuery<T> getCriteriaQuery() {
        return this._criteriaQuery;
    }

    public final void applyParameters(@Nonnull TypedQuery<T> query) {
        for (ParameterSetter parameterSetter : this._parameterSetters) {
            parameterSetter.apply(query);
        }
    }

    @Nonnull
    protected Predicate parse(@Nonnull String criteria) {
        Condition condition = this.parseCondition(criteria);
        return this.processCondition(condition);
    }

    @Nonnull
    protected Condition parseCondition(@Nonnull String criteria) {
        CriteriaParser parser = new CriteriaParser(criteria);
        return parser.getCondition();
    }

    @Nonnull
    protected Predicate processCondition(@Nonnull Condition condition) {
        if (condition instanceof AtomicCondition) {
            return this.processAtomicPredicate((AtomicCondition)condition);
        }
        if (condition instanceof BinaryCondition) {
            return this.processBinaryPredicate((BinaryCondition)condition);
        }
        if (condition instanceof UnaryCondition) {
            return this.processUnaryPredicate((UnaryCondition)condition);
        }
        throw new BadConditionException("Invalid condition");
    }

    @Nonnull
    protected Predicate processAtomicPredicate(@Nonnull AtomicCondition condition) {
        AtomicCondition.Operator operator = condition.getOperator();
        switch (operator) {
            case EQUALS: {
                return this.processEqualsCondition(condition);
            }
            case NOT_EQUALS: {
                return this.processNotEqualsCondition(condition);
            }
            case GREATER_THAN: {
                return this.processGreaterThanCondition(condition);
            }
            case LESS_THAN: {
                return this.processLessThanCondition(condition);
            }
            case GREATER_THAN_OR_EQUALS: {
                return this.processGreaterThanOrEqualsCondition(condition);
            }
            case LESS_THAN_OR_EQUALS: {
                return this.processLessThanOrEqualsCondition(condition);
            }
        }
        throw new BadConditionException("Invalid operator in atomic predicate: " + (Object)((Object)operator));
    }

    @Nonnull
    protected Predicate processNotEqualsCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().notEqual(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected Predicate processEqualsCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().equal(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected <Y extends Comparable<? super Y>> Predicate processGreaterThanCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().greaterThan(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected <Y extends Comparable<? super Y>> Predicate processLessThanCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().lessThan(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected <Y extends Comparable<? super Y>> Predicate processGreaterThanOrEqualsCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().greaterThanOrEqualTo(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected <Y extends Comparable<? super Y>> Predicate processLessThanOrEqualsCondition(@Nonnull AtomicCondition condition) {
        return this.getCriteriaBuilder().lessThanOrEqualTo(this.processVariableExpression(condition.getLhs()), this.processExpression(condition.getRhs()));
    }

    @Nonnull
    protected Expression<?> processExpression(@Nonnull org.realityforge.rest.criteria.model.Expression expression) {
        if (expression instanceof ConstantExpression) {
            return this.processConstantExpression((ConstantExpression)expression);
        }
        if (expression instanceof VariableExpression) {
            return this.processVariableExpression((VariableExpression)expression);
        }
        throw new BadConditionException("Invalid expression");
    }

    @Nonnull
    protected Expression<?> processConstantExpression(final @Nonnull ConstantExpression expression) {
        if (expression.isBoolean()) {
            final ParameterExpression p = this.getCriteriaBuilder().parameter(Boolean.class);
            this.addParameterSetter(new ParameterSetter<T>(){

                @Override
                public void apply(@Nonnull TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asBoolean());
                }
            });
            return p;
        }
        if (expression.isNumeric()) {
            final ParameterExpression p = this.getCriteriaBuilder().parameter(Number.class);
            this.addParameterSetter(new ParameterSetter<T>(){

                @Override
                public void apply(@Nonnull TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asNumeric());
                }
            });
            return p;
        }
        if (expression.isText()) {
            final ParameterExpression p = this.getCriteriaBuilder().parameter(String.class);
            this.addParameterSetter(new ParameterSetter<T>(){

                @Override
                public void apply(@Nonnull TypedQuery<T> typedQuery) {
                    typedQuery.setParameter((Parameter)p, (Object)expression.asText());
                }
            });
            return p;
        }
        throw new BadConditionException("Invalid constant expression: " + expression.getValue());
    }

    protected void addParameterSetter(@Nonnull ParameterSetter<T> setter) {
        this._parameterSetters.add(setter);
    }

    @Nonnull
    protected abstract Expression<?> processVariableExpression(@Nonnull VariableExpression var1);

    @Nonnull
    protected Predicate processBinaryPredicate(@Nonnull BinaryCondition condition) {
        switch (condition.getOperator()) {
            case AND: {
                return this.processAndPredicate(condition);
            }
            case OR: {
                return this.processOrPredicate(condition);
            }
        }
        throw new BadConditionException("Invalid binary predicate");
    }

    @Nonnull
    protected Predicate processOrPredicate(@Nonnull BinaryCondition condition) {
        return this.getCriteriaBuilder().or((Expression)this.processCondition(condition.getLhs()), (Expression)this.processCondition(condition.getRhs()));
    }

    @Nonnull
    protected Predicate processAndPredicate(@Nonnull BinaryCondition condition) {
        return this.getCriteriaBuilder().and((Expression)this.processCondition(condition.getLhs()), (Expression)this.processCondition(condition.getRhs()));
    }

    @Nonnull
    protected Predicate processUnaryPredicate(@Nonnull UnaryCondition condition) {
        switch (condition.getOperator()) {
            case NOT: {
                return this.processNotPredicate(condition);
            }
        }
        throw new BadConditionException("Invalid unary predicate");
    }

    @Nonnull
    protected Predicate processNotPredicate(@Nonnull UnaryCondition condition) {
        return this.getCriteriaBuilder().not((Expression)this.processCondition(condition.getCondition()));
    }

    protected static interface ParameterSetter<T> {
        public void apply(@Nonnull TypedQuery<T> var1);
    }
}

