/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.rest.criteria.tree;

import javax.annotation.Nonnull;
import org.realityforge.rest.criteria.model.AtomicCondition;
import org.realityforge.rest.criteria.model.BinaryCondition;
import org.realityforge.rest.criteria.model.Condition;
import org.realityforge.rest.criteria.model.ConstantExpression;
import org.realityforge.rest.criteria.model.Expression;
import org.realityforge.rest.criteria.model.UnaryCondition;
import org.realityforge.rest.criteria.model.VariableExpression;
import org.realityforge.rest.criteria.tree.CriteriaListener;

public final class TreeWalker {
    private TreeWalker() {
    }

    public static void walk(@Nonnull Condition condition, @Nonnull CriteriaListener listener) {
        TreeWalker.processCondition(condition, listener);
    }

    protected static void processCondition(@Nonnull Condition condition, @Nonnull CriteriaListener listener) {
        if (condition instanceof AtomicCondition) {
            TreeWalker.processAtomicPredicate((AtomicCondition)condition, listener);
        } else if (condition instanceof BinaryCondition) {
            TreeWalker.processBinaryPredicate((BinaryCondition)condition, listener);
        } else if (condition instanceof UnaryCondition) {
            TreeWalker.processUnaryPredicate((UnaryCondition)condition, listener);
        } else {
            throw new IllegalStateException("Invalid condition");
        }
    }

    protected static void processAtomicPredicate(@Nonnull AtomicCondition condition, @Nonnull CriteriaListener listener) {
        AtomicCondition.Operator operator = condition.getOperator();
        switch (operator) {
            case EQUALS: {
                TreeWalker.processEqualsCondition(condition, listener);
                break;
            }
            case NOT_EQUALS: {
                TreeWalker.processNotEqualsCondition(condition, listener);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operator in atomic predicate: " + (Object)((Object)operator));
            }
        }
    }

    protected static void processNotEqualsCondition(@Nonnull AtomicCondition condition, @Nonnull CriteriaListener listener) {
        listener.startNotEqualsCondition(condition);
        listener.variableExpression(condition.getLhs());
        TreeWalker.processExpression(condition.getRhs(), listener);
        listener.endNotEqualsCondition(condition);
    }

    protected static void processEqualsCondition(@Nonnull AtomicCondition condition, @Nonnull CriteriaListener listener) {
        listener.startEqualsCondition(condition);
        listener.variableExpression(condition.getLhs());
        TreeWalker.processExpression(condition.getRhs(), listener);
        listener.endEqualsCondition(condition);
    }

    protected static void processExpression(@Nonnull Expression expression, @Nonnull CriteriaListener listener) {
        if (expression instanceof ConstantExpression) {
            listener.constantExpression((ConstantExpression)expression);
        } else if (expression instanceof VariableExpression) {
            listener.variableExpression((VariableExpression)expression);
        } else {
            throw new IllegalStateException("Invalid expression");
        }
    }

    protected static void processBinaryPredicate(@Nonnull BinaryCondition condition, @Nonnull CriteriaListener listener) {
        switch (condition.getOperator()) {
            case AND: {
                TreeWalker.processAndPredicate(condition, listener);
                break;
            }
            case OR: {
                TreeWalker.processOrPredicate(condition, listener);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid binary predicate");
            }
        }
    }

    protected static void processOrPredicate(@Nonnull BinaryCondition condition, @Nonnull CriteriaListener listener) {
        listener.startOrPredicate(condition);
        TreeWalker.processCondition(condition.getLhs(), listener);
        TreeWalker.processCondition(condition.getRhs(), listener);
        listener.endOrPredicate(condition);
    }

    protected static void processAndPredicate(@Nonnull BinaryCondition condition, @Nonnull CriteriaListener listener) {
        listener.startAndPredicate(condition);
        TreeWalker.processCondition(condition.getLhs(), listener);
        TreeWalker.processCondition(condition.getRhs(), listener);
        listener.endAndPredicate(condition);
    }

    protected static void processUnaryPredicate(@Nonnull UnaryCondition condition, @Nonnull CriteriaListener listener) {
        switch (condition.getOperator()) {
            case NOT: {
                TreeWalker.processNotPredicate(condition, listener);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid unary predicate");
            }
        }
    }

    protected static void processNotPredicate(@Nonnull UnaryCondition condition, @Nonnull CriteriaListener listener) {
        listener.startNotPredicate(condition);
        TreeWalker.processCondition(condition.getCondition(), listener);
        listener.endNotPredicate(condition);
    }
}

