/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import sting.processor.InjectableDescriptor;
import sting.processor.StingGeneratorUtil;
import sting.processor.StingProcessor;
import sting.processor.vendor.javapoet.MethodSpec;
import sting.processor.vendor.javapoet.TypeName;
import sting.processor.vendor.javapoet.TypeSpec;
import sting.processor.vendor.proton.GeneratorUtil;

final class InjectableGenerator {
    private InjectableGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull InjectableDescriptor injectable) {
        TypeElement element = injectable.getElement();
        TypeSpec.Builder builder = TypeSpec.classBuilder(StingGeneratorUtil.getGeneratedClassName(element)).addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        GeneratorUtil.addOriginatingTypes(element, builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, StingProcessor.class.getName());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        TypeMirror returnType = element.asType();
        MethodSpec.Builder creator = MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).returns(TypeName.get(returnType));
        StringBuilder code = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        code.append("return new $T");
        args.add(returnType);
        builder.addMethod(StingGeneratorUtil.buildBindingCreator(processingEnv, creator, code, args, returnType, injectable.getBinding()));
        return builder.build();
    }
}

