/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.List;
import javax.annotation.Nonnull;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class StingTypesUtil {
    private StingTypesUtil() {
    }

    static boolean containsArrayType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!StingTypesUtil.containsArrayType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return TypeKind.ARRAY == type.getKind();
    }

    static boolean containsRawType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty() && !((TypeElement)declaredType.asElement()).getTypeParameters().isEmpty()) {
                return true;
            }
            for (TypeMirror typeMirror : typeArguments) {
                if (!StingTypesUtil.containsRawType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean containsWildcard(@Nonnull TypeMirror type) {
        if (TypeKind.WILDCARD == type.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!StingTypesUtil.containsWildcard(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

