/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.json.stream.JsonGenerator;
import javax.lang.model.element.TypeElement;
import sting.processor.IncludeDescriptor;
import sting.processor.InputDescriptor;
import sting.processor.ServiceDescriptor;

final class InjectorDescriptor {
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final Collection<IncludeDescriptor> _includes;
    @Nonnull
    private final List<InputDescriptor> _inputs;
    @Nonnull
    private final List<ServiceDescriptor> _outputs;
    private boolean _containsError;

    InjectorDescriptor(@Nonnull TypeElement element, @Nonnull Collection<IncludeDescriptor> includes, @Nonnull List<InputDescriptor> inputs, @Nonnull List<ServiceDescriptor> outputs) {
        this._element = Objects.requireNonNull(element);
        this._includes = Objects.requireNonNull(includes);
        this._inputs = Objects.requireNonNull(inputs);
        this._outputs = Objects.requireNonNull(outputs);
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    Collection<IncludeDescriptor> getIncludes() {
        return this._includes;
    }

    @Nonnull
    List<InputDescriptor> getInputs() {
        return this._inputs;
    }

    @Nonnull
    List<ServiceDescriptor> getOutputs() {
        return this._outputs;
    }

    boolean containsError() {
        return this._containsError;
    }

    void markAsContainsError() {
        this._containsError = true;
    }

    void write(JsonGenerator g) {
        g.writeStartObject();
        g.write("schema", "injector/1");
        if (!this._includes.isEmpty()) {
            g.writeStartArray("includes");
            for (IncludeDescriptor include : this._includes) {
                g.write(include.getIncludedType().toString());
            }
            g.writeEnd();
        }
        if (!this._inputs.isEmpty()) {
            g.writeStartArray("inputs");
            for (InputDescriptor input : this._inputs) {
                input.write(g);
            }
            g.writeEnd();
        }
        if (!this._outputs.isEmpty()) {
            g.writeStartArray("outputs");
            for (ServiceDescriptor dependency : this._outputs) {
                dependency.write(g);
            }
            g.writeEnd();
        }
        g.writeEnd();
    }
}

