/*
 * Decompiled with CFR 0.152.
 */
package sting.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.stream.JsonGenerator;
import sting.processor.Binding;
import sting.processor.Coordinate;
import sting.processor.FragmentDescriptor;
import sting.processor.FragmentNode;
import sting.processor.InjectableDescriptor;
import sting.processor.InjectorDescriptor;
import sting.processor.InputDescriptor;
import sting.processor.Node;
import sting.processor.ServiceSpec;

final class ComponentGraph {
    @Nonnull
    private final InjectorDescriptor _injector;
    @Nonnull
    private final Set<String> _includedTypes = new HashSet<String>();
    @Nonnull
    private final Map<Coordinate, List<Binding>> _publishedTypes = new LinkedHashMap<Coordinate, List<Binding>>();
    @Nonnull
    private final Map<String, Node> _nodesById = new HashMap<String, Node>();
    @Nonnull
    private final Node _rootNode;
    private boolean _complete;
    @Nullable
    private List<Node> _orderedNodes;
    @Nullable
    private List<FragmentNode> _fragmentNodes;

    ComponentGraph(@Nonnull InjectorDescriptor injector) {
        this._injector = Objects.requireNonNull(injector);
        this._rootNode = new Node(this);
    }

    @Nonnull
    InjectorDescriptor getInjector() {
        return this._injector;
    }

    @Nonnull
    Node getRootNode() {
        return this._rootNode;
    }

    @Nonnull
    Collection<Node> getRawNodeCollection() {
        return this._nodesById.values();
    }

    @Nonnull
    Node findOrCreateNode(@Nonnull Binding binding) {
        assert (!this._complete);
        String id = binding.getId();
        Node node = this._nodesById.get(id);
        if (null == node) {
            Node newNode = this.createNode(binding);
            this._nodesById.put(id, newNode);
            return newNode;
        }
        return node;
    }

    @Nonnull
    private Node createNode(@Nonnull Binding binding) {
        String id = binding.getId();
        assert (!this._nodesById.containsKey(id));
        Node node = new Node(this, binding);
        this._nodesById.put(id, node);
        return node;
    }

    @Nonnull
    List<Node> getNodes() {
        assert (null != this._orderedNodes);
        return this._orderedNodes;
    }

    @Nonnull
    List<FragmentNode> getFragments() {
        assert (null != this._fragmentNodes);
        return this._fragmentNodes;
    }

    void complete() {
        assert (!this._complete);
        this._complete = true;
        AtomicInteger index = new AtomicInteger();
        HashMap fragmentMap = new HashMap();
        this._fragmentNodes = this._nodesById.values().stream().filter(Node::isFromProvides).map(n -> (FragmentDescriptor)n.getBinding().getOwner()).sorted(Comparator.comparing(FragmentDescriptor::getQualifiedTypeName)).map(f -> new FragmentNode((FragmentDescriptor)f, "fragment" + index.incrementAndGet())).peek(f -> fragmentMap.put(f.getFragment(), f)).collect(Collectors.toList());
        index.set(0);
        this._orderedNodes = this._nodesById.values().stream().sorted(Comparator.comparing(Node::getDepth).thenComparing(n -> n.getBinding().getId()).reversed()).peek(n -> n.setName("node" + index.incrementAndGet())).peek(n -> {
            if (n.isFromProvides()) {
                n.setFragment((FragmentNode)fragmentMap.get(n.getBinding().getOwner()));
            }
        }).collect(Collectors.toList());
    }

    private void registerBinding(@Nonnull Binding binding) {
        for (ServiceSpec service : binding.getPublishedServices()) {
            this._publishedTypes.computeIfAbsent(service.getCoordinate(), c -> new ArrayList()).add(binding);
        }
    }

    @Nonnull
    List<Binding> findAllBindingsByCoordinate(@Nonnull Coordinate coordinate) {
        return this._publishedTypes.getOrDefault(coordinate, Collections.emptyList());
    }

    void registerInput(@Nonnull InputDescriptor input) {
        Binding binding = input.getBinding();
        this.registerBinding(binding);
        this.findOrCreateNode(binding);
    }

    void registerInjectable(@Nonnull InjectableDescriptor injectable) {
        String typeName = injectable.getElement().getQualifiedName().toString();
        if (this._includedTypes.add(typeName)) {
            Binding binding = injectable.getBinding();
            this.registerBinding(binding);
            if (binding.isEager()) {
                this.findOrCreateNode(binding);
            }
        }
    }

    void registerFragment(@Nonnull FragmentDescriptor fragment) {
        String typeName = fragment.getElement().getQualifiedName().toString();
        if (this._includedTypes.add(typeName)) {
            for (Binding binding : fragment.getBindings()) {
                this.registerBinding(binding);
            }
        }
    }

    void write(JsonGenerator g) {
        g.writeStartObject();
        g.write("schema", "graph/1");
        g.writeStartArray("nodes");
        for (Node node : this.getNodes()) {
            node.write(g);
        }
        g.writeEnd();
        g.writeEnd();
    }
}

